<?php

if (!function_exists('register_social_sidebar')) {
    add_action('init', 'register_social_sidebar');
    function register_social_sidebar()
    {
        if (function_exists('register_sidebar')) {
            register_sidebar(array(
                'id' => 'social-sidebar',
                'name' => __('Social Media en contact', 'base-theme'),
                'description' => __('Deze widgets worden weergegeven aan de linker kant van het scherm.', 'base-theme'),
                'class' => '',
                'before_widget' => '<div class="widget">',
                'after_widget' => '</div>',
                'before_title' => '<h3>',
                'after_title' => '</h3>'
            ));
        }
    }
}

if (!function_exists('enqueue_social_side_menu_style_and_script')) {
    add_action('wp_enqueue_scripts', 'enqueue_social_side_menu_style_and_script');
    function enqueue_social_side_menu_style_and_script()
    {
        wp_register_script('social-side-menu-script', get_template_directory_uri() . '/modules/social-side-menu/social-side-menu.js', array(), '1.0', true);
        wp_enqueue_script('social-side-menu-script');
        wp_enqueue_style('social-side-menu-style', get_template_directory_uri() . '/modules/social-side-menu/social-side-menu.css', array(), '1.0', 'all');
    }
}