<?php

if (!function_exists('register_base_theme_sidebars')) {
    add_action('init', 'register_base_theme_sidebars');
    function register_base_theme_sidebars()
    {
        if (function_exists('register_sidebar')) {
            $sidebars = array(
                array(
                    'id' => 'primary-sidebar',
                    'name' => __('Primaire sidebar', 'base-theme'),
                    'class' => '',
                    'before_widget' => '<div class="widget %2$s">',
                    'after_widget' => '</div>',
                    'before_title' => '<span class="sr-only">',
                    'after_title' => '</span>',
                ),
                array(
                    'id' => 'archive-news-sidebar',
                    'name' => __('Nieuws archief sidebar', 'yndenz'),
                    'description' => __('Deze widgets worden weergegeven op het nieuws overzicht.', 'yndenz'),
                    'class' => '',
                    'before_widget' => '<div class="widget %2$s">',
                    'after_widget' => '</div>',
                    'before_title' => '<span class="sr-only">',
                    'after_title' => '</span>',
                ),
                array(
                    'id' => 'single-news-sidebar',
                    'name' => __('Nieuws bericht sidebar', 'yndenz'),
                    'description' => __('Deze widgets worden weergegeven op de nieuws pagina\'s.', 'yndenz'),
                    'class' => '',
                    'before_widget' => '<div class="widget %2$s">',
                    'after_widget' => '</div>',
                    'before_title' => '<h2 class="widget-title">',
                    'after_title' => '</h2>',
                ),
                array(
                    'id' => 'search-sidebar',
                    'name' => __('Zoekenresultaten sidebar', 'yndenz'),
                    'description' => __('Deze widgets worden weergegeven op de zoekresultaten pagina.', 'yndenz'),
                    'class' => '',
                    'before_widget' => '<div class="widget %2$s">',
                    'after_widget' => '</div>',
                    'before_title' => '<span class="sr-only">',
                    'after_title' => '</span>',
                )
            );
            $sidebars = apply_filters('register_base_sidebars', $sidebars);
            foreach ($sidebars as $sidebar) {
                register_sidebar($sidebar);
            }
        }
    }
}