// viewport sizing browser compatibility
(function ($, window) {
    var $win = $(window), _css = $.fn.css;

    function viewportToPixel(val) {
        var vwh_match = val.match(/[vwh]+/);
        var digits_match = val.match(/\d+/);
        if (vwh_match && vwh_match.length && digits_match && digits_match.length) {
            return (vwh_match[0] == 'vh' ? $win.height() : $win.width()) * (digits_match[0] / 100) + 'px';
        }
        return val;
    }

    function parseProps(props) {
        var p, prop;
        for (p in props) {
            prop = props[p];
            if (/[vwh]$/.test(prop)) {
                props[p] = viewportToPixel(prop);
            }
        }
        return props;
    }

    $.fn.css = function (props) {
        var self = this,
            originalArguments = arguments,
            update = function () {
                if (typeof props === 'string' || props instanceof String) {
                    if (originalArguments.length > 1) {
                        var argumentsObject = {};
                        argumentsObject[originalArguments[0]] = originalArguments[1];
                        return _css.call(self, parseProps($.extend({}, argumentsObject)));
                    } else {
                        return _css.call(self, props);
                    }
                } else {
                    return _css.call(self, parseProps($.extend({}, props)));
                }
            };
        $win.resize(update);
        return update();
    };
}(jQuery, window));

window.gridFloatBreakpoint = 992;

$(function () {
    $('img').each(function () {
        if ($(this).hasClass('lazy')) {
            $(this).show().lazyload({
                effect: 'fadeIn',
                event: 'load'
            });
        } else if ($(this).hasClass('lazy-sporty')) {
            $(this).show().lazyload({
                effect: 'fadeIn',
                event: 'sporty'
            });
        } else if (this.complete) {
            $(this).load();
        }
    });

    setTimeout(function () {
        $('img.lazy-sporty').trigger('sporty');
    }, 1500);
});
