<?php

class Facebook
{

    private $posts = array();
    private $page_id;
    private $app_id;
    private $app_secret;
    private $limit = 10;

    function __construct($page_id = null, $app_id = null, $app_secret = null, $limit = null)
    {
        if (!is_null($page_id)) {
            $this->page_id = $page_id;
        } else if (defined('FACEBOOK_PAGE_ID')) {
            $this->page_id = FACEBOOK_PAGE_ID;
        }
        if (!is_null($app_id)) {
            $this->app_id = $app_id;
        } else if (defined('FACEBOOK_APP_ID')) {
            $this->app_id = FACEBOOK_APP_ID;
        }
        if (!is_null($app_secret)) {
            $this->app_secret = $app_secret;
        } else if (defined('FACEBOOK_APP_SECRET')) {
            $this->app_secret = FACEBOOK_APP_SECRET;
        }
        if (!is_null($limit)) {
            $this->limit = $limit;
        }

        $this->load_posts();
    }

    function load_posts()
    {
        $url = "https://graph.facebook.com/".$this->page_id."/feed";
        $url.= "?limit=".$this->limit;
        $url.= '&access_token='.$this->app_id.'|'.$this->app_secret;

        //Data reqeust
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $response = curl_exec($ch);
        curl_close($ch);

        $decoded_response = json_decode($response);
        $this->posts = $decoded_response->data;
    }

    function display()
    {
        for ($i = 0; $i < $this->limit; $i++) :
            $post = $this->posts[$i];
            list($page_id, $post_id) = explode("_", $post->id);
            include(locate_template('module-facebook-gallery.php'));
        endfor;
    }

    function gallery()
    {
        include(locate_template('module-facebook-gallery.php'));
    }

}