<?php
load_theme_textdomain('base-theme', get_stylesheet_directory() . '/languages');

new \BaseTheme\Basics\ThemeSupport();
new \BaseTheme\Basics\Menu();
new \BaseTheme\Basics\Sidebars();
new \BaseTheme\Basics\Scripts();

if (!function_exists('print_rr')) {
    /**
     * This custom version of print_r saves a lot of typing.
     * Fancy displays the type and content of $var.
     *
     * @param mixed $var
     */
    function print_rr($var) {
        echo '<pre>';
        print_r($var);
        echo '</pre>';
    }
}

if (!function_exists('dd')) {
    /**
     * Dump and die.
     * Use for development only!
     *
     * @uses print_rr()
     *
     * @param mixed $var
     */
    function dd($var) {
        print_rr($var);
        die();
    }
}

if (!function_exists('is_yndenz')) {
    /**
     * Check if the visitor is an yndenz employee.
     *
     * @param string $IP
     *
     * @return bool
     */
    function is_yndenz($IP = '80.114.221.1') {
        return $_SERVER['REMOTE_ADDR'] === $IP;
    }
}

if (!function_exists('read_more_button')) {
    add_shortcode('read_more_button', 'read_more_button');
    function read_more_button($args, $content)
    {
        $defaults = array(
            'href' => get_the_permalink(),
            'title' => get_post_meta(get_the_ID(), '_yoast_wpseo_title', true),
            'text' => __('Lees meer', 'base-theme') . ' &raquo;'
        );
        $defaults = apply_filters('default_read_more_button_args', $defaults);
        if (!empty($content)) {
            $defaults['text'] = $content;
        }
        $args = wp_parse_args($args, $defaults);

        ob_start();
        ?>
        <a href="<?php echo $args['href']; ?>" class="btn btn-link btn-read-more"
           title="<?php echo $args['title']; ?>">
            <?php echo $args['text']; ?>
        </a>
        <?php
        return ob_get_clean();
    }
}

if (!function_exists('display_image')) {
    add_shortcode('display_image', 'display_image');
    function display_image($atts)
    {
        $class = '';
        if (array_key_exists('class', $atts)) {
            $class = $atts['class'];
        }
        return wp_get_attachment_image($atts['id'], $atts['size'], false, array('class' => $class));
    }
}

/**
 * autoptimize_filter_css_replacetag: where in the HTML is optimized CSS injected
 *
 * @param array $location array containing the html-tag and the method (inject "before", "after" or "replace")
 * @return array with updated values
 */
add_filter('autoptimize_filter_css_replacetag', 'custom_autoptimize_css_location', 10, 1);
function custom_autoptimize_css_location($location)
{
    $location[0] = "</head>"; // tag
    $location[1] = "before"; // injection
    return $location;
}
