<?php

namespace BaseTheme\Modules;

class CallToAction extends BaseModule {

    public function __construct() {
        parent::__construct();

        add_shortcode('call_to_action', array($this, 'display'));
    }

    public function register() {
        if (!function_exists("register_field_group")) {
            return;
        }

        register_field_group(array(
            'id' => 'acf_call-to-action',
            'title' => __('Call To Action', 'base-theme'),
            'fields' => array(
                array(
                    'key' => 'acf-cta_action',
                    'label' => __('Actie', 'base-theme'),
                    'name' => 'cta_action',
                    'type' => 'select',
                    'choices' => array(
                        'contact-form' => __('Contactformulier popup', 'base-theme'),
                        'request-quickscan' => __('Quickscan aanvraag popup', 'base-theme'),
                        'link-to-page' => __('Link naar pagina', 'base-theme'),
                    ),
                    'default_value' => '',
                    'allow_null' => 1,
                    'multiple' => 0,
                ),
                array(
                    'key' => 'acf-cta_text',
                    'label' => __('Tekst', 'base-theme'),
                    'name' => 'cta_text',
                    'type' => 'text',
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'acf-cta_title',
                    'label' => __('Titel', 'base-theme'),
                    'name' => 'cta_title',
                    'type' => 'text',
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'none',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'acf-cta_page_id',
                    'label' => __('Pagina', 'base-theme'),
                    'name' => 'cta_page_id',
                    'type' => 'post_object',
                    'conditional_logic' => array(
                        'status' => 1,
                        'rules' => array(
                            array(
                                'field' => 'acf-cta_action',
                                'operator' => '==',
                                'value' => 'link-to-page',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'post_type' => array(
                        0 => 'post',
                        1 => 'page',
                    ),
                    'taxonomy' => array(
                        0 => 'all',
                    ),
                    'allow_null' => 0,
                    'multiple' => 0,
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'post',
                        'order_no' => 0,
                        'group_no' => 0,
                    ),
                ),
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'page',
                        'order_no' => 0,
                        'group_no' => 1,
                    ),
                    array(
                        'param' => 'page_type',
                        'operator' => '!=',
                        'value' => 'front_page',
                        'order_no' => 1,
                        'group_no' => 1,
                    ),
                ),
            ),
            'options' => array(
                'position' => 'side',
                'layout' => 'default',
                'hide_on_screen' => array(),
            ),
            'menu_order' => 0,
        ));
    }

    /**
     * Display the call to action.
     *
     * @return string
     */
    public function display() {
        ob_start();
        get_template_part('module', 'call-to-action');
        return ob_get_clean();
    }

}