<?php

namespace BaseTheme\Modules\InteractiveMap;

use BaseTheme\Modules\BaseModule;

class InteractiveMap extends BaseModule {

    public function __construct() {
        parent::__construct();

        add_shortcode('interactive_map', array($this, 'display'));
    }

    /**
     * Enqueue the required JavaScript and styling.
     */
    public function enqueue()
    {
        wp_register_script('jquery-responsive-image-mapping', get_template_directory_uri() . '/bower_components/jQuery-rwdImageMaps/jquery.rwdImageMaps.min.js', array(), '1.0', true);
        wp_register_script('interactive-map-script', get_template_directory_uri() . '/modules/interactive-map/interactive-map.js', array('jquery-responsive-image-mapping'), '1.0', true);
        wp_enqueue_script('interactive-map-script');
    }

    /**
     * Display the interactive map.
     *
     * @return string
     */
    public function display()
    {
        ob_start();
        get_template_part('module', 'interactive-map');
        return ob_get_clean();
    }
}