<?php

namespace BaseTheme\Modules\Gallery;

use BaseTheme\Modules\BaseModule;

class Gallery extends BaseModule {

    public function __construct() {
        parent::__construct();

        add_filter('post_gallery', array($this, 'bootstrapGallery'), 100, 3);
    }

    /**
     * Enqueue the gallery JavaScript and styling
     */
    public function enqueue() {
        wp_register_script('gallery', get_template_directory_uri() . '/modules/Gallery/gallery.js', array(), '1.0', true);
        wp_enqueue_script('gallery');
    }

    /**
     * Convert WordPress galleries into bootstrap carousels.
     *
     * @param string $output The gallery as WordPress displays it
     * @param array $atts
     *
     * @return string
     */
    public function bootstrapGallery($output, $atts) {
        if (array_key_exists('ids', $atts)) {
            $images = explode(',', $atts['ids']);
            ob_start();
            include(locate_template('module-gallery.php'));
            $output = ob_get_clean();
        }
        return $output;
    }

}