<?php

namespace BaseTheme\Modules\SocialSideMenu;

use BaseTheme\Modules\BaseModule;

class SocialSideMenu extends BaseModule {

    /**
     * Register a sidebar to completely customize the menu in WP Admin.
     */
    public function register() {
        if (!function_exists('register_sidebar')) {
            return;
        }

        register_sidebar(array(
            'id' => 'social-sidebar',
            'name' => __('Social Media en contact', 'base-theme'),
            'description' => __('Deze widgets worden weergegeven aan de linker kant van het scherm.', 'base-theme'),
            'class' => '',
            'before_widget' => '<div class="widget">',
            'after_widget' => '</div>',
            'before_title' => '<h3>',
            'after_title' => '</h3>'
        ));
    }

    /**
     * Enqueue the social side menu JavaScript and styling
     */
    public function enqueue() {
        wp_register_script('social-side-menu-script', get_template_directory_uri() . '/modules/SocialSideMenu/social-side-menu.js', array(), '1.0', true);
        wp_enqueue_script('social-side-menu-script');
        wp_enqueue_style('social-side-menu-style', get_template_directory_uri() . '/modules/SocialSideMenu/social-side-menu.css', array(), '1.0', 'all');
    }

    /**
     * Display the social side menu.
     */
    public function display() {
        dynamic_sidebar('social-sidebar');
    }

}