<div class="list-posts">
    <?php while (have_posts()) : the_post(); ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class('item'); ?>>
            <header>
                <?php if ($instance['show_thumbnail']) : ?>
                    <a href="<?php the_permalink(); ?>" class="image-container"
                       title="<?php echo get_post_meta(get_the_ID(), '_yoast_wpseo_title', true); ?>">
                                    <span class="image-wrapper">
                                        <?php
                                        $banner = new Banner(null, 'medium');
                                        $banner->displayImage();
                                        ?>
                                    </span>
                    </a>
                <?php endif; ?>
                <h3 class="post-title">
                    <a href="<?php the_permalink(); ?>"
                       title="<?php echo get_post_meta(get_the_ID(), '_yoast_wpseo_title', true); ?>">
                        <?php the_title(); ?>
                    </a>
                </h3>
                <?php if ($instance['show_date']) : ?>
                    <p class="post-date">
                        <time datetime="<?php echo get_the_date('c'); ?>">
                            <small><?php the_time(get_option('date_format')); ?></small>
                        </time>
                    </p>
                <?php endif; ?>
            </header>
            <?php if ($instance['show_excerpt']) : ?>
                <p class="post-content"><?php the_excerpt(); ?></p>
            <?php endif; ?>
            <p class="text-right">
                <?php echo do_shortcode('[read_more_button]'); ?>
            </p>
        </article>
    <?php endwhile; ?>
</div>