<?php

namespace BaseTheme\Basics;

use wpdb;

class ThemeSupport {

    public function __construct() {
        add_theme_support('menus');
        add_theme_support('post-thumbnails');
        add_filter('widget_text', 'do_shortcode');

        // Hide source output comment for "W3 Total Cache" plugin
        add_filter('w3tc_can_print_comment', '__return_false', 10, 1);

        // Hide ads for "Sucuri Scan" plugin
        if (!defined('SUCURISCAN_HIDE_ADS')) {
            define('SUCURISCAN_HIDE_ADS', true);
        }

        add_filter('logout_url', array($this, 'forceLogoutRedirectToHome'), 102, 2);
        add_filter('wp_pagenavi', array($this, 'bootstrapPagination'), 10, 2);
        add_filter('wpcf7_form_action_url', array($this, 'wpcf7FormAction'));
    }

    /**
     * Force redirect to base url after logout, because it'll redirect you to login by default resulting in a 404.
     *
     * @param string $logout_url
     *
     * @return string
     */
    public function forceLogoutRedirectToHome($logout_url) {
        $redir = home_url();
        $logout_url = preg_replace('/&amp;redirect_to([^&]+)/', '&amp;redirect_to=' . urlencode($redir), $logout_url);
        return $logout_url;
    }

    /**
     * Convert WP_PageNavi pagination to bootstrap pagination.
     */
    public function bootstrapPagination($out) {
        $out = str_replace("<div class='wp-pagenavi'>", '<ul class="pagination">', $out);
        $out = str_replace("</div>", '</ul>', $out);
        $out = str_replace('<a', '<li><a', $out);
        $out = str_replace('</a>', '</a></li>', $out);
        $out = str_replace('<span', '<li><span', $out);
        $out = str_replace('</span>', '</span></li>', $out);
        return $out;
    }

    /**
     * Change Contact Form 7 action URL to homepage URL to prevent redirect and 404 errors on submitting forms.
     *
     * @param string $url
     *
     * @return string
     */
    public function wpcf7FormAction($url) {
        return site_url() . '/' . strstr($url, '#');
    }

    public static function getCompanyLogo($size = 'medium', $title = null) {
        $company_logo_id = of_get_option('company_logo');
        if (!empty($company_logo_id) && !is_numeric($company_logo_id)) :
            /** @var $wpdb wpdb */
            global $wpdb;
            $company_logo_id = $wpdb->get_var("SELECT ID FROM {$wpdb->posts} WHERE guid = '{$company_logo_id}' AND post_type = 'attachment'");
        endif;

        if (empty($title)) {
            $front_page = get_post(get_option('page_on_front'));
            SEO::title($front_page);
        }

        return wp_get_attachment_image($company_logo_id, $size, false, array('alt' => $title, 'title' => $title));
    }

}