<?php

namespace BaseTheme\Modules;

/**
 * Class BaseModule
 * @package BaseTheme\Modules
 *
 * @method void register Register anything required for your theme. Uses setup_theme action.
 * @method void enqueue Enqueue any styles and scripts required for your theme. Uses wp_enqueu_scripts action.
 */
class BaseModule {

    /**
     * BaseModule constructor.
     *
     * If register function exists, it is added to the setup_theme action.
     * If enqueue function exists, it is added to the wp_enqueue_scripts action.
     */
    public function __construct() {
        if (method_exists($this, 'register')) {
            add_action('setup_theme', array($this, 'register'));
        }
        if (method_exists($this, 'enqueue')) {
            add_action('wp_enqueue_scripts', array($this, 'enqueue'));
        }
    }

}