<?php
if (is_single() && in_category('nieuws')) {
    $action = 'link-to-page';
} else {
    $action = get_field('cta_action');
}

if (!empty($action) && $action !== 'null') :
    $text = get_field('cta_text');
    $title = get_field('cta_title');

    if ($action === 'link-to-page') :
        $button = '<a href="%s" title="%s" class="btn">%s</a>';

        $cta_page_id = get_field('cta_page_id');
        if ((empty($cta_page_id) || $cta_page_id === 'null') && is_single() && in_category('nieuws')) {
            $cat = get_category_by_slug('nieuws');
            $category_link = get_category_link($cat->term_id);
            if (strstr($_SERVER['HTTP_REFERER'], $category_link) || preg_match('#/tag/#i', $_SERVER['HTTP_REFERER'])) {
                $permalink = $_SERVER['HTTP_REFERER'];
            } else {
                $permalink = $category_link;
            }
            $text = __('Terug naar overzicht', 'base-theme');
            $title = __('Terug naar overzicht | ' . get_bloginfo('name'), 'base-theme');
        } else {
            $permalink = get_permalink($cta_page_id);
        }

        $action = $permalink;
    else :
        $button = '<button type="button" class="btn" data-toggle="modal" data-target="#%s-popup" title="%s">%s</button>';
    endif;
    ?>
    <div class="call-to-action">
        <?php printf($button, $action, $title, $text); ?>
    </div>
<?php endif; ?>
