<div class="org vcard" itemprop="publisher" itemscope itemtype="http://schema.org/Organization">
    <address class="author">
        <p class="organization-name fn">
            <a class="url" itemprop="url" href="<?php echo home_url('/'); ?>">
                <span itemprop="name"><?php echo of_get_option('company'); ?></span>
            </a>
        </p>
        <div class="adr" itemprop="address" itemscope itemtype="http://schema.org/PostalAddress">
            <p>
                <span class="street-address" itemprop="streetAddress">
                    <?php echo of_get_option('street') . ' ' . of_get_option('number'); ?>
                </span><br>
                <span class="postal-code" itemprop="postalCode">
                    <?php echo of_get_option('zip'); ?>
                </span><br/>
                <span class="locality" itemprop="addressLocality">
                    <?php echo of_get_option('city'); ?>
                </span><br/>
                <span class="tel" itemprop="telephone"
                      content="<?php echo preg_replace('/[^\d\+]+/i', '', preg_replace('/\(.+\)/i', '', of_get_option('phone'))); ?>">
                    <a href="tel:<?php echo preg_replace('/[^\d\+]+/i', '', preg_replace('/\(.+\)/i', '', of_get_option('phone'))); ?>"
                       title="<?php printf(__('Bel %s', 'base-theme'), get_bloginfo('name')); ?>">
                        <?php echo of_get_option('phone'); ?>
                    </a>
                </span><br/>
                <span class="email" itemprop="email">
                    <a href="mailto:<?php echo get_option('admin_email'); ?>"
                       title="<?php printf(__('Stuur een e-mail naar %s', 'base-theme'), get_bloginfo('name')); ?>">
                        <?php echo get_option('admin_email'); ?>
                    </a>
                </span>
            </p>
            <p class="social">
                <?php
                $social = get_option('wpseo_social');
                $allowed_keys = ['facebook_site', 'twitter_site', 'linkedin_url', 'google_plus_url', 'youtube_url'];
                $urls = array_filter(array_intersect_key($social, array_flip($allowed_keys)));
                foreach ($urls as $key => $url) :
                    if ($key === 'twitter_site') :
                        $url = 'https://www.twitter.com/' . $url;
                    endif;
                    ?>
                    <a itemprop="sameAs" href="<?php echo $url; ?>" rel="nofollow">
                        <i class="fa fa-<?php echo str_replace('_', '-', str_replace(array('_site', '_url'), '', $key)); ?>"></i>
                    </a>
                    <?php
                endforeach;
                ?>
            </p>
        </div>
        <?php $company_logo_id = of_get_option('company_logo');
        if (!empty($company_logo_id)) : ?>
            <div class="sr-only" itemprop="logo" itemscope itemtype="http://schema.org/ImageObject">
                <?php
                if (!is_numeric($company_logo_id)) :
                    global $wpdb;
                    $company_logo_id = $wpdb->get_var($wpdb->prepare("SELECT ID FROM {$wpdb->posts} WHERE guid = '%s' AND post_type = 'attachment'", $company_logo_id));
                endif;
                $alt_title = get_post_meta(get_option('page_on_front'), '_yoast_wpseo_title', true);
                echo wp_get_attachment_image($company_logo_id, 'medium', false, array('alt' => $alt_title, 'title' => $alt_title, 'itemprop' => 'url', 'class' => 'img-responsive'));
                ?>
            </div>
        <?php endif; ?>
    </address>
</div>

