<?php

namespace BaseTheme\Basics;

use WP_Query;

class Search {

    public function __construct() {
        add_action('wp_ajax_nopriv_search_auto_complete', array($this, 'autoComplete'));
        add_action('wp_ajax_search_auto_complete', array($this, 'autoComplete'));
    }

    /**
     * Get the search results for auto complete.
     */
    public function autoComplete() {
        $limit = 4;

        $args = wp_parse_args($_REQUEST, array(
            'post_status' => 'publish',
            'posts_per_page' => $limit,
            's' => ''
        ));

        $args = apply_filters('base_theme_basics_search_auto_complete_args', $args);

        $output = $this->autoCompleteFAQAnwers($args, $limit);

        if (count($output) >= $limit) {
            wp_send_json($output);
        }

        $search_terms = strtolower($args['s']);

        $search = new WP_Query($args);
        if ($search->have_posts()) {
            $output = array_merge($output, array_map(array($this, 'autoCompleteResult'), $search->posts, $search_terms));
        }

        wp_send_json(apply_filters('base_theme_basics_search_auto_complete', $output));
    }

    /**
     * Format the result to be used in JavaScript.
     *
     * @param $result
     * @param $search_terms
     *
     * @return array
     */
    protected function autoCompleteResult($result, $search_terms) {
        $text = get_the_title($result);
        similar_text(strtolower($text), $search_terms, $similarity);

        return array(
            'permalink' => get_permalink($result),
            'title' => SEO::title($result),
            'text' => $text,
            'similarity' => $similarity
        );
    }

    /**
     * If there is a FAQ, check the FAQ for answers first.
     *
     * @param $args
     * @param $limit
     *
     * @return array
     */
    protected function autoCompleteFAQAnwers(&$args, $limit) {
        $output = array();

        $autocomplete_questions = of_get_option('autocomplete_questions');
        if (empty($autocomplete_questions)) {
            return $output;
        }

        $lines = array_filter(preg_split('/((\r?\n)|(\r\n?))/', $autocomplete_questions));

        foreach ($lines as $line) {
            list($question, $permalink) = explode(';', $line);

            if (!empty($question) && !empty($permalink)) {
                similar_text(strtolower($question), strtolower($args['s']), $similarity);

                array_push($output, array(
                    'permalink' => trim($permalink),
                    'title' => trim($question),
                    'text' => trim($question),
                    'similarity' => $similarity
                ));
            }
        }

        usort($output, function ($a, $b) {
            return $b['similarity'] - $a['similarity'];
        });

        if (count($output) > $limit) {
            return array_slice($output, 0, $limit);
        }

        $args['posts_per_page'] -= count($output);

        return $output;
    }

}