<?php

namespace BaseTheme\Modules\InteractiveMap;

use BaseTheme\Modules\BaseModule;

class InteractiveMap extends BaseModule {

    public function __construct() {
        parent::__construct();

        add_shortcode('interactive_map', array($this, 'display'));
    }

    /**
     * Get the scripts used for the interactive map.
     *
     * @return array
     */
    protected function getScripts() {
        return array(
            'jquery-responsive-image-mapping' => array('src' => get_template_directory_uri() . '/bower_components/jQuery-rwdImageMaps/jquery.rwdImageMaps.min.js'),
            'interactive-map-script' => array('src' => get_template_directory_uri() . '/modules/interactive-map/interactive-map.js')
        );
    }

    /**
     * Display the interactive map.
     *
     * @return string
     */
    public function display()
    {
        ob_start();
        include(locate_template('partials/modules/interactive-map.php'));
        return ob_get_clean();
    }
}