<?php

namespace BaseTheme\Modules\SocialSideMenu;

use BaseTheme\Modules\BaseModule;

class SocialSideMenu extends BaseModule {

    /**
     * Register a sidebar to completely customize the menu in WP Admin.
     */
    public function register() {
        if (!function_exists('register_sidebar')) {
            return;
        }

        register_sidebar(array(
            'id' => 'social-sidebar',
            'name' => __('Social Media en contact', 'base-theme'),
            'description' => __('Deze widgets worden weergegeven aan de linker kant van het scherm.', 'base-theme'),
            'class' => '',
            'before_widget' => '<div class="widget">',
            'after_widget' => '</div>',
            'before_title' => '<h3>',
            'after_title' => '</h3>'
        ));
    }

    /**
     * Get the scripts used for the social side menu.
     *
     * @return array
     */
    protected function getScripts() {
        return array(
            'social-side-menu-script' => array('src' => get_template_directory_uri() . '/modules/SocialSideMenu/social-side-menu.js')
        );
    }

    /**
     * Get the styles used for the social side menu.
     *
     * @return array
     */
    protected function getStyles() {
        return array(
            'social-side-menu-style' => array('src' => get_template_directory_uri() . '/modules/SocialSideMenu/social-side-menu.css')
        );
    }

    /**
     * Display the social side menu.
     */
    public function display() {
        dynamic_sidebar('social-sidebar');
    }

}