<?php

namespace BaseTheme\Modules\Gallery;

use BaseTheme\Modules\BaseModule;
use WP_Query;

class FullScreenGallery extends BaseModule {

    /**
     * Register the slide custom post type.
     */
    public function register() {
        register_post_type('slide', array(
            'labels' => array(
                'name' => __('Slides', 'base-theme'),
                'singular_name' => __('Slide', 'base-theme'),
                'menu_name' => __('Slides', 'base-theme'),
                'name_admin_bar' => __('Slide', 'base-theme'),
                'add_new' => __('Toevoegen', 'base-theme'),
                'add_new_item' => __('Slide toevoegen', 'base-theme'),
                'new_item' => __('Nieuwe slide', 'base-theme'),
                'edit_item' => __('Bewerken', 'base-theme'),
                'view_item' => __('Bekijken', 'base-theme'),
                'all_items' => __('Alle slides', 'base-theme'),
                'search_items' => __('Slides zoeken', 'base-theme'),
                'not_found' => __('Geen slides gevonden.', 'base-theme'),
                'not_found_in_trash' => __('Geen slides gevonden in de prullenbak.', 'base-theme'),
            ),
            'description' => __('Homepage slides', 'base-theme'),
            'public' => false,
            'publicly_queryable' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            'menu_position' => 20,
            'menu_icon' => 'dashicons-format-gallery',
            'capability_type' => 'post',
            'has_archive' => false,
            'hierarchical' => false,
            'supports' => array('title', 'editor', 'thumbnail')
        ));
    }

    /**
     * Get the scripts used for the full-screen gallery.
     *
     * @return array
     */
    protected function getScripts() {
        return array(
            'full-screen-gallery-script' => array('src' => get_template_directory_uri() . '/modules/Gallery/full-screen-gallery.js')
        );
    }

    /**
     * Get the styles used for the full-screen gallery.
     *
     * @return array
     */
    protected function getStyles() {
        return array(
            'full-screen-gallery-style' => array('src' => get_template_directory_uri() . '/modules/Gallery/full-sreen-gallery.css')
        );
    }

    /**
     * Display the full-screen gallery.
     */
    public function display() {
        $slides = new WP_Query(array(
            'post_type' => 'slide',
            'posts_per_page' => -1,
            'orderby' => 'menu_order'
        ));
        if ($slides->have_posts()) :
            include(locate_template('partials/modules/full-screen-gallery.php'));
        endif;
    }

}