window.parallaxBanner = function () {
    $.event.trigger({
        type: 'beforeParallaxBanner'
    });

    var banner = $('.banner');

    if ($(window).width() < window.gridFloatBreakpoint) {
        banner.css({paddingTop: $('body > header').height()});
        return;
    } else {
        banner.css({paddingTop: ''});
    }

    if ($(window).scrollTop() < banner.height()) {
        $('.banner .banner-inner').css({marginTop: $(window).scrollTop() / 2, marginBottom: ($(window).scrollTop() / 2) * -1});
        if ($(window).scrollTop() / banner.height() < 0.9) {
            $('.banner .banner-content').css({opacity: 1 - (($(window).scrollTop() / banner.height()) * 1.5)});
        }
    }

    $.event.trigger({
        type: 'afterParallaxBanner'
    });
};

$(function () {
    if ($('.banner')) {
        $(window).on('resize orientationchange scroll scrollstart touchmove', function () {
            window.parallaxBanner();
        });

        window.parallaxBanner();
    }
});