<?php

namespace BaseTheme\Modules\SubPages;

use BaseTheme\Modules\BaseModule;

class SubPages extends BaseModule {

    protected $pages = array();
    protected $num_pages;

    public function __construct($num_pages = 5) {
        parent::__construct();

        $this->num_pages = $num_pages;
    }

    /**
     * Register subpages as custom fields.
     */
    public function register() {
        if (!function_exists("register_field_group")) {
            return;
        }

        $fields = array();
        for ($i = 1; $i <= $this->num_pages; $i++) {
            array_push($fields, array(
                'key' => "acf-subpage_{$i}_text",
                'label' => sprintf(__('Blok %d', 'base-theme'), $i),
                'name' => "subpage_{$i}_text",
                'type' => 'textarea',
                'default_value' => '',
                'placeholder' => '',
                'maxlength' => '',
                'rows' => '',
                'formatting' => 'html',
            ));
        }

        $locations = array(
            array(
                array(
                    'param' => 'page_type',
                    'operator' => '==',
                    'value' => 'front_page',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
        );

        $locations = apply_filters('module_subpages_locations', $locations);

        register_field_group(array(
            'id' => 'acf_subpages',
            'title' => __('Subpagina\'s', 'base-theme'),
            'fields' => $fields,
            'location' => $locations,
            'options' => array(
                'position' => 'normal',
                'layout' => 'no_box',
                'hide_on_screen' => array(),
            ),
            'menu_order' => 0,
        ));
    }

    /**
     * Get the scripts used for the sub-pages.
     *
     * @return array
     */
    public function getScripts() {
        return array(
            'subpages-script' => array('src' => get_template_directory_uri() . '/modules/SubPages/subpages.js')
        );
    }

    /**
     * Get the styles used for the sub-pages.
     *
     * @return array
     */
    public function getStyles() {
        return array(
            'subpages-style' => array('src' => get_template_directory_uri() . '/modules/SubPages/subpages.css')
        );
    }

    /**
     * Initialize the subpages content.
     */
    public function initialize() {
        for ($i = 1; $i <= $this->num_pages; $i++) {
            $content = get_post_meta(get_the_ID(), "subpage_{$i}_text", true);
            if (!empty($content)) {
                $content = apply_filters('the_content', $content);
                $content = preg_replace('~<h2>(.*)</h2>~i', '<header><h2>$1</h2></header>', $content);
                array_push($this->pages, $content);
            }
        }
    }

    /**
     * Display a listing of subpages.
     */
    public function display() {
        foreach ($this->pages as $i => $content) :
            include(locate_template('partials/modules/subpages.php'));
        endforeach;
    }

}