(function ($) {
    $.fn.extend({
        navbar: function (options) {
            options = $.extend({}, $.newNavbar.defaults, options);

            this.each(function () {
                new $.newNavbar($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newNavbar = function (target, options) {
        this.target = target;
        this.options = options;
        this.lastScrollTop = 0;
        this.minify = false;
        this.height = target.height();

        this.watch('minify', function (oldVal, val) {
            if (oldVal !== val) {
                if (val) {
                    this.removeClass('nav-up').addClass('nav-down');
                } else {
                    this.removeClass('nav-down').addClass('nav-up');
                }
            }
        });

        this.windowScroll = function () {
            var scrollTop = $(window).scrollTop();

            if (scrollTop === this.lastScrollTop) {
                return;
            }

            if (scrollTop > this.lastScrollTop && scrollTop > this.height) {
                this.minify = true;
            } else {
                if (scrollTop + $(window).height() < $(document).height()) {
                    this.minify = false;
                }
            }

            this.lastScrollTop = scrollTop;
        };
        $(window).on('scroll scrollstart touchmove', this.windowScroll);

        setInterval(this.windowScroll, 100);
    };

    // option defaults
    $.newNavbar.defaults = {};
})(jQuery);

$(function () {
    $('.navbar').navbar();
});