<?php

namespace BaseTheme\Widgets;

use BaseTheme\Modules\Banner\Banner;
use WP_Query;
use WP_Widget;

class RecentPosts extends WP_Widget {

    function __construct() {
        parent::__construct(
            'recent_posts_widget',
            __('Meest recente berichten (by yndenz)', 'base-theme'),
            array(
                'description' => __('Een uitgebreide variant van de meest recente berichten widget.', 'base-theme')
            )
        );

        add_action('widgets_init', array($this, 'register'));
    }

    public function register() {
        register_widget('recent_posts_widget');
    }

    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        echo $args['before_widget'];
        if (!empty($title))
            echo $args['before_title'] . $title . $args['after_title'];

        $query_args = array(
            'post__not_in' => array(get_the_ID()),
            'posts_per_page' => 5,
            'post_type' => 'post',
            'post-status' => 'publish',
            'orderby' => 'date',
            'order' => 'DESC'
        );
        if (!empty($instance['category__in'])) {
            $query_args['category__in'] = explode(',', $instance['category__in']);
        }
        if (!empty($instance['numposts'])) {
            $query_args['posts_per_page'] = (int)$instance['numposts'];
        }

        $posts = new WP_Query($query_args);
        echo '<div class="list-posts">';
        while ($posts->have_posts()) : $posts->the_post();
            ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class('item'); ?>>
                <header>
                    <?php if ($instance['show_thumbnail']) : ?>
                        <a href="<?php the_permalink(); ?>" class="image-container"
                           title="<?php echo get_post_meta(get_the_ID(), '_yoast_wpseo_title', true); ?>">
                                <span class="image-wrapper">
                                    <?php
                                    $banner = new Banner(null, 'medium');
                                    $banner->displayImage();
                                    ?>
                                </span>
                        </a>
                    <?php endif; ?>
                    <h3 class="post-title">
                        <a href="<?php the_permalink(); ?>"
                           title="<?php echo get_post_meta(get_the_ID(), '_yoast_wpseo_title', true); ?>">
                            <?php the_title(); ?>
                        </a>
                    </h3>
                    <?php if ($instance['show_date']) : ?>
                        <p class="post-date">
                            <time datetime="<?php echo get_the_date('c'); ?>">
                                <small><?php the_time(get_option('date_format')); ?></small>
                            </time>
                        </p>
                    <?php endif; ?>
                </header>
                <?php if ($instance['show_excerpt']) : ?>
                    <p class="post-content"><?php the_excerpt(); ?></p>
                <?php endif; ?>
                <p class="text-right">
                    <?php echo do_shortcode('[read_more_button]'); ?>
                </p>
            </article>
            <?php
        endwhile;
        echo '</div>';
        echo $args['after_widget'];
    }

    public function form($instance) {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }
        $numposts = '5';
        if (isset($instance['numposts'])) {
            $numposts = $instance['numposts'];
        }
        $categories = array();
        if (isset($instance['category__in'])) {
            $categories = explode(',', $instance['category__in']);
        }
        $show_thumbnail = '';
        if (isset($instance['show_thumbnail'])) {
            $show_thumbnail = $instance['show_thumbnail'];
        }
        $show_date = '';
        if (isset($instance['show_date'])) {
            $show_date = $instance['show_date'];
        }
        $show_excerpt = '';
        if (isset($instance['show_excerpt'])) {
            $show_excerpt = $instance['show_excerpt'];
        }
        $excerpt_length = '15';
        if (isset($instance['excerpt_length'])) {
            $excerpt_length = $instance['excerpt_length'];
        }
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php _e('Titel:', 'base-theme'); ?>
            </label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" type="text"
                   name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr($title); ?>"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('numposts'); ?>">
                <?php _e('Aantal berichten:', 'base-theme'); ?>
            </label>
            <input class="widefat" id="<?php echo $this->get_field_id('numposts'); ?>" type="text"
                   name="<?php echo $this->get_field_name('numposts'); ?>" value="<?php echo esc_attr($numposts); ?>"/>
        </p>
        <p>
            <label>
                <?php _e('Categorie:', 'base-theme'); ?>
            </label><br/>
            <?php foreach (get_categories() as $category) : ?>
                <input class="checkbox"
                       type="checkbox"<?php echo in_array($category->term_id, $categories) ? ' checked' : ''; ?>
                       id="<?php echo $this->get_field_id('category__in'); ?>-<?php echo $category->term_id; ?>"
                       name="<?php echo $this->get_field_name('category__in'); ?>[<?php echo $category->term_id; ?>]"/>
                <label for="<?php echo $this->get_field_id('category__in'); ?>">
                    <?php echo $category->name; ?>
                </label><br/>
            <?php endforeach; ?>
        </p>
        <p>
            <input class="checkbox" id="<?php echo $this->get_field_id('show_thumbnail'); ?>" type="checkbox"
                   name="<?php echo $this->get_field_name('show_thumbnail'); ?>"<?php echo $show_thumbnail ? ' checked' : ''; ?>/>
            <label for="<?php echo $this->get_field_id('show_thumbnail'); ?>">
                <?php _e('Afbeelding weergeven', 'base-theme'); ?>
            </label><br/>
            <input class="checkbox" id="<?php echo $this->get_field_id('show_date'); ?>" type="checkbox"
                   name="<?php echo $this->get_field_name('show_date'); ?>"<?php echo $show_date ? ' checked' : ''; ?>/>
            <label for="<?php echo $this->get_field_id('show_date'); ?>">
                <?php _e('Datum weergeven', 'base-theme'); ?>
            </label><br/>
            <input class="widefat" id="<?php echo $this->get_field_id('show_excerpt'); ?>" type="checkbox"
                   name="<?php echo $this->get_field_name('show_excerpt'); ?>"<?php echo $show_excerpt === 1 ? ' checked' : ''; ?>/>
            <label for="<?php echo $this->get_field_id('show_excerpt'); ?>">
                <?php _e('Samenvatting weergeven', 'base-theme'); ?>
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('numposts'); ?>">
                <?php _e('Aantal berichten:', 'base-theme'); ?>
            </label>
            <input class="widefat" id="<?php echo $this->get_field_id('excerpt_length'); ?>" type="text"
                   name="<?php echo $this->get_field_name('excerpt_length'); ?>"
                   value="<?php echo esc_attr($excerpt_length); ?>"/>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['category__in'] = (!empty($new_instance['category__in'])) ? implode(array_keys($new_instance['category__in'])) : '';
        $instance['numposts'] = (!empty($new_instance['numposts'])) ? strip_tags($new_instance['numposts']) : '5';
        $instance['show_thumbnail'] = (!empty($new_instance['show_thumbnail'])) ? 1 : 0;
        $instance['show_date'] = (!empty($new_instance['show_date'])) ? 1 : 0;
        $instance['show_excerpt'] = (!empty($new_instance['show_excerpt'])) ? 1 : 0;
        $instance['excerpt_length'] = (!empty($new_instance['excerpt_length'])) ? strip_tags($new_instance['numposts']) : '15';
        return $instance;
    }

}