<?php get_header(); ?>

<?php get_template_part('partials/banner'); ?>

    <div class="content">

        <?php get_template_part('partials/breadcrumb-cta-bar'); ?>

        <section role="main" class="container">
            <header>
                <h1 class="sr-only">
                    <?php
                    if (!empty(get_search_query())) :
                        printf(__('Zoekresultaten voor "%s"', 'base-theme'), get_search_query());
                    else :
                        _e('Zoeken', 'base-theme');
                    endif;
                    ?>
                </h1>
            </header>

            <div class="filters">
                <?php dynamic_sidebar('search-sidebar'); ?>
            </div>

            <?php
            if (have_posts()) :
                if (function_exists('wp_pagenavi')) :
                    ?>
                    <div class="pagination-wrapper">
                        <?php wp_pagenavi(); ?>
                    </div>
                    <?php
                endif;

                get_template_part('partials/loop', 'posts');

                if (function_exists('wp_pagenavi')) :
                    ?>
                    <div class="pagination-wrapper">
                        <?php wp_pagenavi(); ?>
                    </div>
                    <?php
                endif;
            elseif (!empty(get_search_query())) :
                echo apply_filters('the_content', of_get_option('no_search_results_content'));
            endif;
            ?>
        </section>

    </div>

<?php get_footer(); ?>