if (typeof window.swipedetect !== 'function') {
    window.swipedetect = function (el, callback) {
        $.event.trigger({
            type: 'beforeSwipedetect',
            el: el,
            callback: callback
        });

        var touchsurface = el,
            swipedir,
            startX,
            startY,
            distX,
            distY,
            threshold = 150, //required min distance traveled to be considered swipe
            restraint = 100, // maximum distance allowed at the same time in perpendicular direction
            startTime,
            handleswipe = callback || function (swipedir) {
            };

        touchsurface.on('touchstart', function (e) {
            var touchobj = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];
            swipedir = 'none';
            distX = 0;
            distY = 0;
            startX = touchobj.pageX;
            startY = touchobj.pageY;
            startTime = new Date().getTime(); // record time when finger first makes contact with surface
        });

        touchsurface.on('touchend', function (e) {
            var touchobj = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];
            distX = touchobj.pageX - startX; // get horizontal dist traveled by finger while in contact with surface
            distY = touchobj.pageY - startY; // get vertical dist traveled by finger while in contact with surface
            if (Math.abs(distX) >= threshold && Math.abs(distY) <= restraint) { // 2nd condition for horizontal swipe met
                swipedir = (distX < 0) ? 'left' : 'right'; // if dist traveled is negative, it indicates left swipe
            }
            else if (Math.abs(distY) >= threshold && Math.abs(distX) <= restraint) { // 2nd condition for vertical swipe met
                swipedir = (distY < 0) ? 'up' : 'down'; // if dist traveled is negative, it indicates up swipe
            }
            handleswipe(swipedir);
        });

        $.event.trigger({
            type: 'afterSwipedetect',
            el: el,
            callback: callback
        });
    };
}

(function ($) {
    $.fn.extend({
        gallery: function (options) {
            options = $.extend({}, $.newGallery.defaults, options);

            this.each(function () {
                new $.newGallery($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newGallery = function (target, options) {
        this.target = target;
        this.options = options;

        this.navigate = function (dir) {
            if (dir === 'left') {
                this.target.carousel('prev');
            } else if (dir === 'right') {
                this.target.carousel('next');
            }
        };
        window.swipedetect(target, this.navigate);
    };

    // option defaults
    $.newGallery.defaults = {};
})(jQuery);

$(function () {
    $('.gallery').gallery();
});