<?php

load_theme_textdomain('base-theme', get_stylesheet_directory() . '/languages');

new \BaseTheme\Basics\ThemeSupport();
new \BaseTheme\Basics\Menu();
new \BaseTheme\Basics\Sidebars();
new \yndenz\Modules\ViewportToPixel\ViewportToPixel();
new \BaseTheme\Basics\Scripts();

add_filter('auto_update_plugin', '__return_false');

if (!function_exists('force_logout_home')) {
    /**
     * Force redirect to base url after logout, because it'll redirect you to /wp-core/ by default, which will result in a 404.
     *
     * @return string
     */
    add_filter('logout_url', 'force_logout_home', 102, 2);
    function force_logout_home($logouturl)
    {
        $redir = 'http://www.' . $_SERVER['HTTP_HOST'] . '/';
        $logouturl = preg_replace('/&amp;redirect_to([^&]+)/', '&amp;redirect_to=' . urlencode($redir), $logouturl);
        return $logouturl;
    }
}

if (!function_exists('print_rr')) {
    /**
     * This custom version of print_r saves a lot of typing
     *
     * @param mixed $var the variable to display
     */
    function print_rr($var)
    {
        echo '<pre>';
        print_r($var);
        echo '</pre>';
    }
}

if (!function_exists('dd')) {
    /**
     * Dump and die.
     * Use for development only!
     *
     * @uses print_rr()
     *
     * @param mixed $var
     */
    function dd($var) {
        print_rr($var);
        die();
    }
}

if (!function_exists('is_yndenz')) {
    /**
     * Check if the visitor is an yndenz employee.
     *
     * @param string $IP
     *
     * @return bool
     */
    function is_yndenz($IP = '83.86.200.128')
    {
        return $_SERVER['REMOTE_ADDR'] === $IP;
    }
}

if (!function_exists('read_more_button')) {
    add_shortcode('read_more_button', 'read_more_button');
    function read_more_button($args, $content)
    {
        $defaults = array(
            'href' => get_the_permalink(),
            'title' => get_seo_title(),
            'text' => __('Lees meer', 'base-theme') . ' &raquo;'
        );
        $defaults = apply_filters('default_read_more_button_args', $defaults);
        if (!empty($content)) {
            $defaults['text'] = $content;
        }
        $args = wp_parse_args($args, $defaults);

        ob_start();
        ?>
        <a href="<?php echo $args['href']; ?>" class="btn btn-link btn-read-more"
           title="<?php echo $args['title']; ?>">
            <?php echo $args['text']; ?>
        </a>
        <?php
        return ob_get_clean();
    }
}

if (!function_exists('display_image')) {
    add_shortcode('display_image', 'display_image');
    function display_image($atts)
    {
        $class = '';
        if (array_key_exists('class', $atts)) {
            $class = $atts['class'];
        }
        return wp_get_attachment_image($atts['id'], $atts['size'], false, array('class' => $class));
    }
}

/**
 * autoptimize_filter_css_replacetag: where in the HTML is optimized CSS injected
 *
 * @param array $location array containing the html-tag and the method (inject "before", "after" or "replace")
 * @return array with updated values
 */
add_filter('autoptimize_filter_css_replacetag', 'custom_autoptimize_css_location', 10, 1);
function custom_autoptimize_css_location($location)
{
    $location[0] = "</head>"; // tag
    $location[1] = "before"; // injection
    return $location;
}

function get_company_logo($size = 'medium', $title = null) {
    return \BaseTheme\Basics\ThemeSupport::getCompanyLogo($size, $title);
}

/**
 * Search for attachment ID using guid/URL.
 *
 * @param $guid
 * @return bool|int Attachment ID, or false if attachment could not be found.
 */
function get_attachment_id_from_url($guid)
{
    global $wpdb;

    $attachment_id = $wpdb->get_var($wpdb->prepare("SELECT ID FROM {$wpdb->posts} WHERE guid = '%s' AND post_type = 'attachment'", $guid));

    if (!is_numeric($attachment_id)) {
        return false;
    }

    return intval($attachment_id);
}