<?php

/*
 * Helper function to return the theme option value. If no value has been saved, it returns $default.
 * Needed because options are saved as serialized strings.
 *
 */
if (!function_exists('of_get_option')) {
    function of_get_option($name, $default = false)
    {
        $optionsframework_settings = get_option('optionsframework');
        // Gets the unique option id
        $option_name = $optionsframework_settings['id'];
        if (get_option($option_name)) {
            $options = get_option($option_name);
        }
        if (isset($options[$name])) {
            return $options[$name];
        } else {
            return $default;
        }
    }
}

if (!function_exists('custom_theme_options_menu_params')) {
    /*
     * Change the menu title name and slug
     */
    add_filter('optionsframework_menu', 'custom_theme_options_menu_params');
    function custom_theme_options_menu_params($menu)
    {
        $menu['page_title'] = __('Thema instellingen', 'base-theme');
        $menu['menu_title'] = __('Thema instellingen', 'base-theme');
        $menu['menu_slug'] = 'theme-options';
        return $menu;
    }
}

if (!function_exists('optionsframework_option_name')) {
    /**
     * A unique identifier is defined to store the options in the database and reference them from the theme.
     * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
     * If the identifier changes, it'll appear as if the options have been reset.
     *
     */
    function optionsframework_option_name()
    {
        // This gets the theme name from the stylesheet (lowercase and without spaces)
        $themename = get_option('stylesheet');
        $themename = preg_replace('/\W/', "_", strtolower($themename));
        $optionsframework_settings = get_option('optionsframework');
        $optionsframework_settings['id'] = $themename;
        update_option('optionsframework', $optionsframework_settings);
    }
}

if (!function_exists('optionsframework_options')) {
    /**
     * Defines an array of options that will be used to generate the settings page and be saved in the database.
     * When creating the "id" fields, make sure to use all lowercase and no spaces.
     */
    function optionsframework_options()
    {
        $wp_editor_settings = array(
            'wpautop' => false,
            'textarea_rows' => 5,
            'tinymce' => array('plugins' => 'wordpress,wplink')
        );

        $options = array();
        $options[] = array("name" => __('Bedrijf', 'base-theme'),
            "type" => "heading");
        $options['company'] = array(
            "name" => __('Bedrijfsnaam', 'base-theme'),
            "id" => "company",
            'std' => '',
            "type" => "text");
        $options['street'] = array(
            "name" => __('Straat', 'base-theme'),
            "id" => "street",
            'std' => '',
            "type" => "text");
        $options['number'] = array(
            "name" => __('Nummer', 'base-theme'),
            "id" => "number",
            'std' => '',
            "type" => "text");
        $options['zip'] = array(
            "name" => __('Postcode', 'base-theme'),
            "id" => "zip",
            'std' => '',
            "type" => "text");
        $options['city'] = array(
            "name" => __('Plaats', 'base-theme'),
            "id" => "city",
            'std' => '',
            "type" => "text");
        $options['phone'] = array(
            "name" => __('Telefoonnummer', 'base-theme'),
            "id" => "phone",
            'std' => '',
            "type" => "text");
        $options['company_logo'] = array(
            "name" => __('Logo', 'base-theme'),
            "id" => "company_logo",
            "type" => "upload");
        $options['copyright_start'] = array(
            "name" => __('Copyright jaar', 'base-theme'),
            "id" => "copyright_start",
            'std' => '',
            "type" => "text");

        $options = apply_filters('optionsframework_options_filter_company', $options, $wp_editor_settings);

        $options[] = array("name" => __('404 Pagina niet gevonden', 'base-theme'),
            "type" => "heading");
        $options['404_page_banner'] = array(
            "name" => __('Banner', 'base-theme'),
            "id" => "404_page_banner",
            "type" => "upload");
        $options['404_page_content'] = array(
            'name' => __('Content', 'base-theme'),
            'id' => '404_page_content',
            'std' => '',
            'type' => 'editor',
            'settings' => $wp_editor_settings);

        $options = apply_filters('optionsframework_options_filter_404', $options, $wp_editor_settings);

        $options[] = array("name" => __('Zoeken', 'base-theme'),
            "type" => "heading");
        $options['search_banner'] = array(
            "name" => __('Banner', 'base-theme'),
            "id" => "search_banner",
            "type" => "upload");
        $options['no_search_results_content'] = array(
            'name' => __('Geen resultaten gevonden', 'base-theme'),
            'id' => 'no_search_results_content',
            'std' => '',
            'type' => 'editor',
            'settings' => $wp_editor_settings);

        $options = apply_filters('optionsframework_options_filter_search', $options, $wp_editor_settings);

        $options[] = array("name" => __('Tags', 'base-theme'),
            "type" => "heading");
        $options['default_tag_banner'] = array(
            "name" => __('Default banner', 'base-theme'),
            "id" => "default_tag_banner",
            "type" => "upload");
        $options['default_tag_banner_content'] = array(
            'name' => __('Default content', 'base-theme'),
            'id' => 'default_tag_banner_content',
            'std' => '',
            'type' => 'editor',
            'settings' => $wp_editor_settings);

        $options = apply_filters('optionsframework_options_filter_tags', $options, $wp_editor_settings);

        $options = apply_filters('optionsframework_options_filter', $options, $wp_editor_settings);

        return $options;
    }
}