<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta http-equiv="content-type" content="text/html; charset=<?php bloginfo('charset'); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <base href="<?php echo esc_url(home_url('/')); ?>">
    <title><?php wp_title('|'); ?></title>
    <link href="https://www.google-analytics.com" rel="dns-prefetch">
    <link href="https://code.jquery.com" rel="dns-prefetch">
    <?php wp_head(); ?>
</head>

<?php
$body_microformats = is_single() ? ' itemscope itemtype="http://schema.org/NewsArticle"' : ' itemscope itemtype="http://schema.org/WebPage"';
$body_microformats = apply_filters('body_microformats', $body_microformats);
?>
<body <?php body_class(); echo $body_microformats; ?>>

<header>
    <?php
    if (class_exists('\\yndenz\\Modules\\Navigation\\Navbar')) :
        $navbar = new \yndenz\Modules\Navigation\Navbar();
        $navbar->display();
    else :
        echo '<nav>';
        wp_nav_menu(array('theme_location' => 'navbar'));
        echo '</nav>';
    endif;
    ?>
</header>