<div class="row loop">
    <?php
    global $post;
    while (have_posts()) :
        the_post();
        $seo_title = get_seo_title($post);
        if (empty($seo_title)) :
            $seo_title = get_the_title();
        endif;
        ?>
        <div class="item col-xs-12 col-sm-12 col-sm-original-4 col-md-4 col-lg-4">
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <header>
                    <a href="<?php the_permalink(); ?>" class="image-container" title="<?php echo $seo_title; ?>">
                        <span class="image-wrapper">
                            <?php
                            if (class_exists('\\yndenz\\Modules\\Banner\\Banner')) :
                                $banner = new \yndenz\Modules\Banner\Banner();
                                $banner->initialize(null, 'medium');
                                $banner->displayImage();
                            elseif (has_post_thumbnail()) :
                                the_post_thumbnail();
                            endif;
                            ?>
                        </span>
                    </a>
                    <?php
                    if (is_archive() && is_main_query()) :
                        printf('<h2 class="post-title"><a href="%s" title="%s">%s</a></h2>', get_permalink(), $seo_title, get_the_title());
                    else :
                        printf('<h3 class="post-title"><a href="%s" title="%s">%s</a></h3>', get_permalink(), $seo_title, get_the_title());
                    endif;
                    ?>
                    <p class="post-date">
                        <time datetime="<?php the_date('c'); ?>">
                            <small><?php the_time(get_option('date_format')); ?></small>
                        </time>
                    </p>
                </header>
                <p class="post-content">
                    <?php the_excerpt(); ?>
                </p>
                <p class="text-right">
                    <?php echo do_shortcode('[read_more_button]'); ?>
                </p>
            </article>
        </div>
    <?php endwhile; ?>
</div>