<?php get_header(); ?>

<?php get_template_part('partials/banner'); ?>

<div class="<?php echo apply_filters('basics_single_content_class', 'content'); ?>">

    <?php get_template_part('partials/breadcrumb-cta-bar'); ?>

    <div class="container">
        <div class="row">
            <section class="col-xs-12 col-sm-12 col-md-10 col-md-offset-1 col-lg-10 col-lg-offset-1" role="main">
                <?php
                global $post;
                $content = $post->post_content;
                if (strpos($post->post_content, '<h1>') === false) :
                    $content = '<h1>' . get_the_title(). '</h1>' . $content;
                endif;
                $content_filtered = apply_filters('the_content', $content);

                ob_start();
                ?>
                <header class="page-header">
                    <h1 itemprop="headline"$1>$2</h1>
                    <time datetime="<?php the_time('Y-m-d'); ?>" itemprop="datePublished" content="<?php the_time('Y-m-d'); ?>">
                        <?php the_time(get_option('date_format')); ?>
                    </time>
                    <meta itemprop="dateModified" content="<?php the_modified_time('Y-m-d'); ?>"/>
                    <meta itemprop="mainEntityOfPage" content="<?php the_permalink(); ?>"/>
                </header>
                <div itemprop="articleBody">
                    <?php
                    $content_restructured = preg_replace('/<h1(.*)>(.*)<\/h1>/is', ob_get_clean(), $content_filtered);
                    $content_restructured = preg_replace('/<p([^>]*)>/is', '<p itemprop="text"$1>', $content_restructured, 1);
                    echo $content_restructured;
                    ?>
                </div>
            </section>
        </div>

        <aside class="sidebar">
            <?php get_sidebar(); ?>
        </aside>
    </div>

</div>

<?php get_footer(); ?>
