<?php

namespace BaseTheme\Basics;

class Scripts {

    public function __construct() {
        add_action('wp_enqueue_scripts', array($this, 'enqueue'));
    }

    public function enqueue() {
        $scripts = $this->getScripts();

        foreach ($scripts as $handle => $script) {
            if (!array_key_exists('dependencies', $script)) {
                $script['dependencies'] = array();
            }
            wp_register_script($handle, $script['src'], $script['dependencies'], false, true);
            wp_enqueue_script($handle);
        }

        $styles = $this->getStyles();

        foreach ($styles as $handle => $stylesheet) {
            if (!array_key_exists('dependencies', $stylesheet)) {
                $stylesheet['dependencies'] = array();
            }
            wp_enqueue_style($handle, $stylesheet['src'], $stylesheet['dependencies'], false, 'all');
        }
    }

    protected function getScripts() {
        $scripts = array();

        if (!is_admin()) {
            // Replace the default jQuery with a placeholder and use the latest jquery (conditionally enqueued in header, because of browser compatibility)
            wp_deregister_script('jquery');
            $scripts['jquery'] = array('src' => get_template_directory_uri() . '/js/jquery-placeholder.js');

            wp_deregister_script('jquery-ui-core');
            $scripts['jquery-ui-core'] = array('src' => get_template_directory_uri() . '/bower_components/jquery-ui/jquery-ui.min.js');
            $scripts['jquery-ui-regional-nl'] = array('src' => get_template_directory_uri() . '/bower_components/jquery-ui/jquery-ui.min.js',
                                                      'dependencies' => array('jquery-ui-core'));
        }

        // Libraries
        $scripts['bootstrap'] = array('src' => get_template_directory_uri() . '/bower_components/bootstrap-sass/assets/javascripts/bootstrap.min.js');
        $scripts['fancybox'] = array('src' => get_template_directory_uri() . '/bower_components/fancybox/source/jquery.fancybox.pack.js');
        $scripts['jq-dropdown-script'] = array('src' => get_template_directory_uri() . '/bower_components/jq-dropdown/jquery.dropdown.js');

        // Base Theme scripts
        $scripts['base-main-script'] = array('src' => get_template_directory_uri() . '/js/main.js');

        return apply_filters('base_theme_basics_scripts', $scripts);
    }

    protected function getStyles() {
        $styles = array();

        // Libraries
        $styles['fancybox-style'] = array('src' => get_template_directory_uri() . '/bower_components/fancybox/source/jquery.fancybox.css');
        $styles['jq-dropdown-styles'] = array('src' => get_template_directory_uri() . '/bower_components/jq-dropdown/jquery.dropdown.css');

        // Baste Theme styles
        $styles['base-fonts'] = array('src' => get_template_directory_uri() . '/style/fonts.css');
        // in this case (custom bootstrap) stylesheet directory because this one is 99% of the times customised in child themes
        $styles['custom-bootstrap-style'] = array('src' => get_stylesheet_directory_uri() . '/style/custom-bootstrap.css');
        $styles['base-style'] = array('src' => get_template_directory_uri() . '/style.css');

        return apply_filters('base_theme_basics_styles', $styles);
    }

}
