<?php

$title = null;
if (is_date()) {
    if (is_category('nieuws')) {
        $title = _e('Nieuws', 'base-theme') . single_month_title(' ', false);
    } else {
        $title = trim(single_month_title(' ', false));
    }
} else if (is_category()) {
    if (is_category('nieuws')) {
        $title = __('Laatste nieuws', 'base-theme');
    } else {
        $title = get_the_category();
    }
} else if (is_tag()) {
    $title = single_tag_title('', false);
}

get_header();
?>

<?php
if (class_exists('\\yndenz\\Modules\\Banner\\Banner')) :
    $banner = new \yndenz\Modules\Banner\Banner();
    $banner->initialize($title);
    $banner->display();
endif;
?>

    <div class="ybt-content">

        <?php get_template_part('partials/breadcrumb-cta-bar'); ?>

        <section role="main" class="container">
            <header class="page-header">
                <h1 class="<?php echo isset($banner) && $banner->isTitleIncluded() ? 'sr-only' : ''; ?>">
                    <?php echo $title; ?>
                </h1>
            </header>

            <?php echo category_description(); ?>

            <?php if (is_category('nieuws') || is_tag()) : ?>
                <div class="ybt-archive-filters">
                    <?php dynamic_sidebar('archive-news-sidebar'); ?>
                </div>
            <?php endif; ?>

            <?php if (function_exists('wp_pagenavi')) : ?>
                <div class="ybt-pagination">
                    <?php wp_pagenavi(); ?>
                </div>
            <?php endif; ?>

            <?php get_template_part('partials/loop', 'posts'); ?>

            <?php if (function_exists('wp_pagenavi')) : ?>
                <div class="ybt-pagination">
                    <?php wp_pagenavi(); ?>
                </div>
            <?php endif; ?>
        </section>

    </div>

<?php get_footer(); ?>