<?php

namespace BaseTheme\Basics;

class Sidebars extends Basics {

    public static function register() {
        if (!function_exists('register_sidebar')) {
            return;
        }

        $sidebars = array(
            'primary-sidebar' => array(
                'name' => __('Primaire sidebar', 'base-theme'),
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ),
            'archive-news-sidebar' => array(
                'name' => __('Nieuws archief sidebar', 'base-theme'),
                'description' => __('Deze widgets worden weergegeven op het nieuws overzicht.', 'base-theme'),
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ),
            'single-news-sidebar' => array(
                'name' => __('Nieuws bericht sidebar', 'base-theme'),
                'description' => __('Deze widgets worden weergegeven op de nieuws pagina\'s.', 'base-theme'),
                'before_title' => '<h2 class="widget-title">',
                'after_title' => '</h2>'
            ),
            'search-sidebar' => array(
                'name' => __('Zoekenresultaten sidebar', 'base-theme'),
                'description' => __('Deze widgets worden weergegeven op de zoekresultaten pagina.', 'base-theme'),
            )
        );

        array_walk($sidebars, function (&$sidebar, $id) {
            $sidebar = wp_parse_args($sidebar, array(
                'id' => $id,
                'class' => '',
                'before_widget' => '<div class="widget %2$s">',
                'after_widget' => '</div>',
            ));
        });

        $sidebars = apply_filters('base_theme_basics_sidebars', $sidebars);

        foreach ($sidebars as $sidebar) {
            register_sidebar($sidebar);
        }
    }

}