<?php

namespace BaseTheme\Basics;

class ThemeSupport extends Basics {

    public static function register() {
        add_theme_support('menus');
        add_theme_support('post-thumbnails');
        add_filter('widget_text', 'do_shortcode');

        add_filter('logout_url', array(static::class, 'forceLogoutRedirectToHome'), 102, 2);
        add_filter('wp_pagenavi', array(static::class, 'bootstrapPagination'));
        //add_filter('wpcf7_form_action_url', array(static::class, 'wpcf7FormAction'));
    }

    /**
     * Force redirect to base url after logout, because it'll redirect you to login by default resulting in a 404.
     *
     * @param string $logout_url
     *
     * @return string
     */
    public static function forceLogoutRedirectToHome($logout_url) {
        $redir = home_url();
        $logout_url = preg_replace('/&amp;redirect_to([^&]+)/', '&amp;redirect_to=' . urlencode($redir), $logout_url);
        return $logout_url;
    }

    /**
     * Convert WP_PageNavi pagination to bootstrap pagination.
     */
    public static function bootstrapPagination($out) {
        $out = str_replace("<div class='wp-pagenavi'", '<ul class="pagination"', $out);
        $out = str_replace("</div>", '</ul>', $out);
        $out = str_replace('<a', '<li><a', $out);
        $out = str_replace('</a>', '</a></li>', $out);
        $out = str_replace('<span', '<li><span', $out);
        $out = str_replace("<li><span class='current'", '<li class="active"><span', $out);
        $out = str_replace('</span>', '</span></li>', $out);
        return $out;
    }

    /**
     * Change Contact Form 7 action URL to homepage URL to prevent redirect and 404 errors on submitting forms.
     *
     * @param string $url
     *
     * @return string
     */
    public static function wpcf7FormAction($url) {
        return site_url() . '/' . strstr($url, '#');
    }

    /**
     * Get company logo ID.
     *
     * @return int|bool ID of the media file, or false if no company logo was set.
     */
    public static function getCompanyLogoID() {
        $company_logo_id = of_get_option('company_logo');

        if (empty($company_logo_id)) {
            return false;
        }

        if (!is_numeric($company_logo_id)) {
            $company_logo_id = get_attachment_id_from_url($company_logo_id);
        }

        return intval($company_logo_id);
    }

    /**
     * Get the company logo image tag.
     *
     * @param string $size
     * @param null $title
     * @return string|bool HTML-img, or false if no company logo was set.
     */
    public static function getCompanyLogo($size = 'medium', $title = null) {
        $company_logo_id = static::getCompanyLogoID();
        if ($company_logo_id === false) {
            return false;
        }

        if (empty($title)) {
            $front_page = get_post(get_option('page_on_front'));
            get_seo_title($front_page);
        }

        return wp_get_attachment_image($company_logo_id, $size, false, array('alt' => $title, 'title' => $title));
    }

    /**
     * Get the URL for the company logo.
     *
     * @param string $size
     * @return string|bool URL of the company logo, or false if no company logo was set.
     */
    public static function getCompanyLogoURL($size = 'medium') {
        $company_logo_id = static::getCompanyLogoID();
        if ($company_logo_id === false) {
            return false;
        }

        $source = wp_get_attachment_image_src($company_logo_id, $size, false);
        if ($source === false) {
            return false;
        }

        list($url,) = $source;
        return $url;
    }

}