<?php

get_header();

if ( class_exists( '\\yndenz\\Modules\\Gallery\\FullScreenGallery' ) ) :
	$fullScreenGallery = new \yndenz\Modules\Gallery\FullScreenGallery();
	$fullScreenGallery->display();
endif;
?>

    <section class="ybt-content" role="main">
		<?php
		while ( have_posts() ) :
			the_post();

            $main_content = restructuredContent();

			if ( class_exists( '\\yndenz\\Modules\\SubPages\\SubPages' ) ) :
				?>
                <div class="ym-sub-pages__wrapper">
                    <table>
                        <tr>
                            <td>
                                <div class="container">
									<?php echo $main_content; ?>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
				<?php
				$subPages = new \yndenz\Modules\SubPages\SubPages();
				$subPages->display();
			else :
				printf( '<div class="container">%s</div>', $main_content );
			endif;

		endwhile;
		?>
    </section>

<?php
query_posts( array(
	'posts_per_page' => 3,
	'offset'         => 0,
	'category'       => 'nieuws',
	'orderby'        => 'post_date',
	'order'          => 'DESC',
	'post_type'      => 'post',
	'post_status'    => 'publish'
) );
if ( have_posts() ) :
	?>
    <aside class="ym-sub-pages__wrapper home-news">
        <div class="container">
            <h3 class="news-header">
                <a href="<?php echo get_category_link( 1 ); ?>"
                   title="<?php get_seo_title( get_category( 1 ) ); ?>">
					<?php _ex( 'Laatste nieuws', 'Homepage', 'base-theme' ); ?>
                </a>
            </h3>

			<?php get_template_part( 'partials/loop', 'posts' ); ?>
        </div>
    </aside>
<?php
endif;
wp_reset_query();
wp_reset_postdata();
?>

<?php get_footer(); ?>