<?php

load_theme_textdomain( 'base-theme', get_stylesheet_directory() . '/languages' );

\yndenz\Modules\ViewportToPixel\ViewportToPixel::init();

\yndenz\Modules\JSON_LD\JSON_LD::init();

\BaseTheme\Basics\Reset::init();
\BaseTheme\Basics\ThemeSupport::init();
\BaseTheme\Basics\Shortcodes::init();
\BaseTheme\Basics\Menu::init();
\BaseTheme\Basics\Sidebars::init();
\BaseTheme\Basics\Scripts::init();

if ( ! function_exists( 'print_rr' ) ) {
	/**
	 * This custom version of print_r saves a lot of typing
	 *
	 * @param mixed $var the variable to display
	 */
	function print_rr( $var ) {
		echo '<pre>';
		print_r( $var );
		echo '</pre>';
	}
}

if ( ! function_exists( 'dd' ) ) {
	/**
	 * Dump and die.
	 * Use for development only!
	 *
	 * @param mixed $var
	 *
	 * @uses print_rr()
	 *
	 */
	function dd( $var ) {
		print_rr( $var );
		die();
	}
}

if ( ! function_exists( 'is_yndenz' ) ) {
	/**
	 * Check if the visitor is an yndenz employee.
	 *
	 * @param string $IP
	 *
	 * @return bool
	 */
	function is_yndenz( $IP = '83.87.228.21' ) {
		return $_SERVER['REMOTE_ADDR'] === $IP;
	}
}

if ( ! function_exists( 'notify_yndenz' ) ) {
	/**
	 * Notify yndenz through Rocket Chat.
	 *
	 * @param string $token The webhook integration token for Rocket Chat
	 * @param string $subject Subject of the message you want to send
	 * @param string $message Message you want to send
	 * @param array $mail_addresses Optional e-mail addresses to send a notification too
	 *
	 * @return bool true if successful, false if request failed, response body if unexpected response
	 */

	function notify_yndenz( $token, $subject, $message, $mail_addresses = array() ) {
		foreach ( $mail_addresses as $mail_address ) {
			wp_mail( $mail_address, $subject, $message );
		}

		$ch   = curl_init( 'https://notify.yndenz.com/hooks/' . $token );
		$data = http_build_query( array(
			'username'    => get_bloginfo( 'name' ),
			'text'        => '',
			'attachments' => array(
				array(
					'title' => $subject,
					'text'  => $message,
				)
			)
		) );
		curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'POST' );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $data );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
		$result = curl_exec( $ch );
		curl_close( $ch );

		if ( empty( $result ) ) {
			return false;
		}

		$result = json_decode( $result, true );

		if ( array_key_exists( 'success', $result ) && $result['success'] ) {
			return true;
		}

		return $result;
	}
}

/**
 * autoptimize_filter_css_replacetag: where in the HTML is optimized CSS injected
 *
 * @param array $location array containing the html-tag and the method (inject "before", "after" or "replace")
 *
 * @return array with updated values
 */
add_filter( 'autoptimize_filter_css_replacetag', 'custom_autoptimize_css_location', 10, 1 );
function custom_autoptimize_css_location( $location ) {
	$location[0] = "</head>"; // tag
	$location[1] = "before"; // injection

	return $location;
}

function get_company_logo( $size = 'medium', $title = null ) {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogo( $size, $title );
}

function get_company_logo_id() {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogoID();
}

function get_company_logo_url( $size = 'medium' ) {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogoURL( $size );
}

add_filter( 'href_phone_number', function ( $phone_number ) {
	return preg_replace( '/[^\d\+]+/i', '', preg_replace( '/\(.+\)/i', '', $phone_number ) );
} );