<?php

namespace BaseTheme\Basics;

class Scripts extends Basics {

    public static function register() {
        add_action('wp_enqueue_scripts', array(static::class, 'enqueue'));
    }

    public static function enqueue() {
        $scripts = static::getScripts();

        foreach ($scripts as $handle => $script) {
            if (!array_key_exists('dependencies', $script)) {
                $script['dependencies'] = array();
            }
            wp_register_script($handle, $script['src'], $script['dependencies'], false, true);
            wp_enqueue_script($handle);
        }

        $styles = static::getStyles();

        foreach ($styles as $handle => $stylesheet) {
            if (!array_key_exists('dependencies', $stylesheet)) {
                $stylesheet['dependencies'] = array();
            }
            wp_enqueue_style($handle, $stylesheet['src'], $stylesheet['dependencies'], false, 'all');
        }
    }

    public static function getScripts() {
        $scripts = array();

        if (!is_admin()) {
            // Replace the default jQuery with a placeholder and use the latest jquery (conditionally enqueued in footer, because of browser compatibility)
            wp_deregister_script('jquery');
            $scripts['jquery'] = array('src' => get_template_directory_uri() . '/node_modules/jquery/dist/jquery.js');

            wp_deregister_script('jquery-ui-core');
            $scripts['jquery-ui-core'] = array('src' => get_template_directory_uri() . '/node_modules/jquery-ui-dist/jquery-ui.js');
        }

        // Libraries
        $scripts['bootstrap'] = array('src' => get_template_directory_uri() . '/node_modules/bootstrap-sass/assets/javascripts/bootstrap.js');
        $scripts['fancybox'] = array('src' => get_template_directory_uri() . '/node_modules/@fancyapps/fancybox/dist/jquery.fancybox.min.js');

        // Base Theme scripts
        $scripts['base-main-script'] = array('src' => get_template_directory_uri() . '/js/main.js');

        return apply_filters('base_theme_basics_scripts', $scripts);
    }

    public static function getStyles() {
        $styles = array();

        // Libraries
        $styles['jquery-ui-style'] = array('src' => get_template_directory_uri() . '/node_modules/jquery-ui-dist/jquery-ui.css');
        $styles['fancybox-style'] = array('src' => get_template_directory_uri() . '/node_modules/@fancyapps/fancybox/dist/jquery.fancybox.min.css');

        // Baste Theme styles
        // in this case (custom bootstrap) stylesheet directory because this one is 99% of the times customised in child themes
        $styles['base-style'] = array('src' => get_template_directory_uri() . '/style.css');

        return apply_filters('base_theme_basics_styles', $styles);
    }

}
