<?php

load_theme_textdomain('base-theme', get_stylesheet_directory() . '/languages');

\yndenz\Modules\ViewportToPixel\ViewportToPixel::init();

\yndenz\Modules\yndenzSEO\SEO::init();

\BaseTheme\Basics\Reset::init();
\BaseTheme\Basics\ThemeSupport::init();
\BaseTheme\Basics\Shortcodes::init();
\BaseTheme\Basics\Menu::init();
\BaseTheme\Basics\Sidebars::init();
\BaseTheme\Basics\Scripts::init();

if (!function_exists('print_rr')) {
    /**
     * This custom version of print_r saves a lot of typing
     *
     * @param mixed $var the variable to display
     */
    function print_rr($var)
    {
        echo '<pre>';
        print_r($var);
        echo '</pre>';
    }
}

if (!function_exists('dd')) {
    /**
     * Dump and die.
     * Use for development only!
     *
     * @uses print_rr()
     *
     * @param mixed $var
     */
    function dd($var) {
        print_rr($var);
        die();
    }
}

if (!function_exists('is_yndenz')) {
    /**
     * Check if the visitor is an yndenz employee.
     *
     * @param string $IP
     *
     * @return bool
     */
    function is_yndenz($IP = '83.86.200.128')
    {
        return $_SERVER['REMOTE_ADDR'] === $IP;
    }
}

/**
 * autoptimize_filter_css_replacetag: where in the HTML is optimized CSS injected
 *
 * @param array $location array containing the html-tag and the method (inject "before", "after" or "replace")
 * @return array with updated values
 */
add_filter('autoptimize_filter_css_replacetag', 'custom_autoptimize_css_location', 10, 1);
function custom_autoptimize_css_location($location)
{
    $location[0] = "</head>"; // tag
    $location[1] = "before"; // injection
    return $location;
}

function get_company_logo($size = 'medium', $title = null) {
    return \BaseTheme\Basics\ThemeSupport::getCompanyLogo($size, $title);
}

function get_company_logo_id() {
    return \BaseTheme\Basics\ThemeSupport::getCompanyLogoID();
}

function get_company_logo_url($size = 'medium') {
    return \BaseTheme\Basics\ThemeSupport::getCompanyLogoURL($size);
}

add_filter('href_phone_number', function($phone_number) {
    return preg_replace('/[^\d\+]+/i', '', preg_replace('/\(.+\)/i', '', $phone_number));
});