<?php

namespace BaseTheme\Basics;

class Shortcodes {

    public static function init() {
        add_shortcode('image', array(static::class, 'image'));
        add_shortcode('display_image', array(static::class, 'image'));
        add_shortcode('fa-icon', array(static::class, 'FontAwesomeIcon'));
        add_shortcode('whitespace', array(static::class, 'whitespace'));
        add_shortcode('read-more', array(static::class, 'readMoreButton'));
        add_shortcode('read_more_button', array(static::class, 'readMoreButton'));
    }

    public static function image($atts = array(), $content = '') {
        if (!is_array($atts)) {
            $atts = shortcode_parse_atts($atts);
        }

        if (!is_array($atts) || empty($atts)) {
            return '';
        }

        $size = 'large';
        if (array_key_exists('size', $atts)) {
            $size = $atts['size'];
        }

        $classes = array('img-responsive');
        if (array_key_exists('align', $atts)) {
            array_push($classes, 'align' . $atts['align']);
        }
        if (array_key_exists('class', $atts)) {
            $classes = array_merge($classes, explode(' ', $atts['class']));
        }
        if (array_key_exists('xclass', $atts)) {
            $classes = array_merge($classes, explode(' ', $atts['xclass']));
        }

        $image = wp_get_attachment_image($atts['image_id'], $size, false, array('class' => implode(' ', $classes)));

        if (array_key_exists('url', $atts)) {
            $url = $atts['url'];

            if (array_key_exists('button', $atts)) {
                $text = $atts['button'];
            } else {
                $path = parse_url($atts['url'], PHP_URL_PATH);
                $post_id = get_page_by_path($path);
                $text = get_the_title($post_id);
            }

            $title = $text;
            if (array_key_exists('title', $atts)) {
                $title = $atts['title'];
            }

            $button = sprintf('<a href="%s" title="%s" class="btn btn-primary">%s</a>', $url, $title, $text);
            return sprintf('<div class="c-image-block">%s%s</div>', $image, $button);
        } else if (array_key_exists('description', $atts)) {
            $style = '';
            if (array_key_exists('width', $atts)) {
                $width = $atts['width'];
                if (is_numeric($width)) {
                    $width .= 'px';
                }
                $style = sprintf(' pull-left" style="width: %s', $width);
            }
            return sprintf('<div class="c-image-block%s">%s<p>%s</p></div>', $style, $image, $atts['description']);
        }

        return $image;
    }

    public static function whitespace($atts = array(), $content = '') {
        if (!is_array($atts)) {
            $atts = shortcode_parse_atts($atts);
        }

        $style = '';
        if (!empty($atts) && is_array($atts) && array_key_exists('width', $atts)) {
            $width = $atts['width'];
            if (is_numeric($width)) {
                $width .= 'px';
            }
            $style = sprintf(' pull-left" style="width: %s', $width);
        }

        return sprintf('<div class="c-whitespace%s"></div>', $style);
    }

    public static function FontAwesomeIcon($atts = array(), $content = '') {
        if (!is_array($atts)) {
            $atts = shortcode_parse_atts($atts);
        }

        if (empty($atts) || !is_array($atts) || !array_key_exists('type', $atts)) {
            return '';
        }

        return sprintf('<i class="fa fa-%s" aria-hidden="true"></i>', $atts['type']);
    }

    public static function readMoreButton($args, $content) {
        $defaults = array(
            'href' => get_the_permalink(),
            'title' => get_seo_title(),
            'text' => __('Lees meer', 'base-theme') . ' &raquo;'
        );
        $defaults = apply_filters('default_read_more_button_args', $defaults);
        if (!empty($content)) {
            $defaults['text'] = $content;
        }
        $args = wp_parse_args($args, $defaults);

        return sprintf('<a href="%s" class="btn btn-link btn-read-more" title="%s">%s</a>', $args['href'], $args['title'], $args['text']);
    }

}