if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.base = yndenz.base || function () {
    return {};
};

yndenz.base.scrollTo = yndenz.base.scrollTo || function () {
    return {};
};

yndenz.base.scrollTo.scrollToElement = function (target, options) {
    this.target = target;
    this.options = options;
    this.element = jQuery(this.target.attr('href'));
};

yndenz.base.scrollTo.scrollToElement.prototype.doScroll = function (e) {
    e.preventDefault();

    var offset;
    if (typeof this.options.offset === 'function') {
        offset = this.options.offset();
    } else if (typeof this.options.offset === 'string' && window[this.options.offset]) {
        offset = window[this.options.offset]();
    } else {
        offset = yndenz.modules.navigation.dropdown.defaults.offset();
    }

    jQuery('body, html').animate({scrollTop: jQuery(this.element).offset().top - offset}, 600);
};

yndenz.base.scrollTo.scrollToElement.defaults = {
    offset: function () {
        var offset = jQuery('body').attr('data-scroll-offset');
        if (offset) {
            return parseInt(offset);
        }
        return 150;
    }
};

(function ($) {
    $.fn.extend({
        scrollToElement: function (options) {
            options = $.extend({}, yndenz.modules.scrollTo.scrollToElement.defaults, options);

            this.each(function () {
                new yndenz.modules.scrollTo.scrollToElement($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.scroll-to, .scroll-to-element').scrollToElement();
});