<?php get_header(); ?>

<?php get_template_part( 'partials/banner' ); ?>

<div class="<?php echo apply_filters( 'basics_single_content_class', 'ybt-content' ); ?>">

	<?php get_template_part( 'partials/breadcrumb-cta-bar' ); ?>

    <div class="container">
        <div class="pure-g">
            <section class="pure-u-1 pure-u-md-2-3 pure-u-lg-3-4" role="main">
				<?php
				global $post;
				$content = $post->post_content;
				if ( strpos( $post->post_content, '<h1>' ) === false ) {
					$content = '<h1>' . get_the_title() . '</h1>' . $content;
				}
				$content_filtered = apply_filters( 'the_content', $content );

				ob_start();
				?>
                <header class="page-header">
                    <h1 itemprop="headline" $1>$2</h1>
                    <time datetime="<?php the_time( 'Y-m-d' ); ?>" itemprop="datePublished"
                          content="<?php the_time( 'Y-m-d' ); ?>">
						<?php the_time( get_option( 'date_format' ) ); ?>
                    </time>
                    <meta itemprop="dateModified" content="<?php the_modified_time( 'Y-m-d' ); ?>">
                    <meta itemprop="mainEntityOfPage" content="<?php the_permalink(); ?>">
                </header>
                <div itemprop="articleBody">
					<?php
					$content_restructured = preg_replace( '/<h1(.*)>(.*)<\/h1>/is', ob_get_clean(), $content_filtered );
					$content_restructured = preg_replace( '/<p([^>]*)>/is', '<p itemprop="text"$1>', $content_restructured, 1 );
					echo $content_restructured;
					?>
                </div>
            </section>

            <aside class="ybt-sidebar pure-u-1 pure-u-md-1-3 pure-u-lg-1-4">
				<?php get_sidebar(); ?>
            </aside>
        </div>
    </div>

</div>

<?php get_footer(); ?>
