<?php

namespace BaseTheme\Basics;

use Walker_Page;

class WalkerSEO extends Walker_Page {

	public function start_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = str_repeat( "\t", $depth );
		$output .= "\n$indent<ul>\n";
	}

	public function start_el( &$output, $page, $depth = 0, $args = array(), $current_page = 0 ) {
		parent::start_el( $output, $page, $depth, $args, $current_page );
		$output = preg_replace( '/href="(.+?)"([^>]*)>(.*)$/', 'href="$1" title="' . get_seo_title( $page ) . '"$2>$3', $output );
	}

}