<?php

get_header();

get_template_part( 'partials/banner' );
get_template_part( 'partials/breadcrumb-cta-bar' );
?>

    <div class="ybt-content">

        <section role="main" class="container">
            <header class="page-header">
                <h1>
					<?php
					if ( ! empty( get_search_query() ) ) {
						printf( _x( 'Zoekresultaten voor "%s"', 'Zoekresultaten', 'base-theme' ), get_search_query() );
					} else {
						_ex( 'Zoeken', 'Zoekresultaten', 'base-theme' );
					}
					?>
                </h1>
            </header>

            <div class="ybt-search-filters">
				<?php dynamic_sidebar( 'search-sidebar' ); ?>
            </div>

			<?php
			if ( have_posts() ) :
				get_template_part( 'partials/loop', 'posts' );

				if ( function_exists( 'wp_pagenavi' ) ) :
					printf( '<div class="ybt-pagination">%s</div>', wp_pagenavi( array(
						'echo'          => false,
						'wrapper_class' => 'pagination'
					) ) );
				endif;
            elseif ( ! empty( get_search_query() ) ) :
				echo apply_filters( 'the_content', of_get_option( 'no_search_results_content' ) );
			endif;
			?>
        </section>

    </div>

<?php get_footer(); ?>