<?php

get_header();

if ( class_exists( '\\yndenz\\Modules\\Banner\\Banner' ) ) :
	$banner = new \yndenz\Modules\Banner\Banner();
	$banner->initialize( get_archive_title() );
	$banner->display();
endif;

get_template_part( 'partials/breadcrumb-cta-bar' );
?>

    <div class="ybt-content">

        <section role="main" class="container">
            <header class="page-header<?php echo isset( $banner ) && $banner->isTitleIncluded() ? ' sr-only' : ''; ?>">
                <h1><?php echo $title; ?></h1>
            </header>

			<?php echo category_description(); ?>

			<?php if ( is_date() || is_post_type_archive( [ 'post' ] ) || is_category() || is_tag() ) : ?>
                <div class="ybt-archive-filters">
					<?php dynamic_sidebar( 'archive-news-sidebar' ); ?>
                </div>
			<?php endif; ?>

			<?php get_template_part( 'partials/loop', 'posts' ); ?>

			<?php
			if ( function_exists( 'wp_pagenavi' ) ) :
				printf( '<div class="ybt-pagination">%s</div>', wp_pagenavi( array(
					'echo'          => false,
					'wrapper_class' => 'pagination'
				) ) );
			endif;
			?>
        </section>

    </div>

<?php get_footer(); ?>