<?php

load_theme_textdomain( 'base-theme', get_stylesheet_directory() . '/languages' );

\yndenz\Modules\yndenzSEO\SEO::init();

\BaseTheme\Basics\Reset::init();
\BaseTheme\Basics\ThemeSupport::init();
\BaseTheme\Basics\ThemeOptions::init();
\BaseTheme\Basics\Shortcodes::init();
\BaseTheme\Basics\Menu::init();
\BaseTheme\Basics\Sidebars::init();
\BaseTheme\Basics\Scripts::init();
\BaseTheme\Basics\Pagination::init();

if ( ! function_exists( 'print_rr' ) ) {
	/**
	 * This custom version of print_r saves a lot of typing
	 *
	 * @param mixed $var the variable to display
	 */
	function print_rr( $var ) {
		echo '<pre>';
		print_r( $var );
		echo '</pre>';
	}
}

if ( ! function_exists( 'dd' ) ) {
	/**
	 * Dump and die.
	 * Use for development only!
	 *
	 * @uses print_rr()
	 *
	 * @param mixed $var
	 */
	function dd( $var ) {
		print_rr( $var );
		die();
	}
}

if ( ! function_exists( 'is_yndenz' ) ) {
	/**
	 * Check if the visitor is an yndenz employee.
	 *
	 * @param string $IP
	 *
	 * @return bool
	 */
	function is_yndenz( $IP = '83.86.200.128' ) {
		return $_SERVER['REMOTE_ADDR'] === $IP;
	}
}

if ( ! function_exists( 'notify_yndenz' ) ) {
	/**
	 * Notify yndenz through Rocket Chat.
	 *
	 * @param string $token          The webhook integration token for Rocket Chat
	 * @param string $subject        Subject of the message you want to send
	 * @param string $message        Message you want to send
	 * @param array  $mail_addresses Optional e-mail addresses to send a notification too
	 *
	 * @return bool true if successful, false if request failed, response body if unexpected response
	 */
	function notify_yndenz( $token, $subject, $message, $mail_addresses = array() ) {
		if ( ! defined( 'YNDENZ_NOTIFICATION_TOKEN' ) ) {
			define( 'YNDENZ_NOTIFICATION_TOKEN', $token );
		}

		return \BaseTheme\Basics\Notification::send( $subject, $message, $mail_addresses );
	}
}

if ( ! function_exists( 'structured_content' ) ) {
	/**
	 * Display the page content using structured data.
	 *
	 * @param bool $echo If false, the page content will be returned.
	 *
	 * @return string|null
	 */
	function structured_content( $echo = true ) {
		if ( class_exists( '\\yndenz\\Modules\\yndenzSEO\\SEO' ) ) {
			$output = \yndenz\Modules\yndenzSEO\SEO::restructuredContent();
		} else {
			$output = sprintf( '<header class="page-header"><h1 itemprop="name">%s</h1></header>%s', get_the_title(), get_the_content() );
		}

		if ( $echo ) {
			echo $output;
		} else {
			return $output;
		}

		return null;
	}
}

/**
 * autoptimize_filter_css_replacetag: where in the HTML is optimized CSS injected
 *
 * @param array $location array containing the html-tag and the method (inject "before", "after" or "replace")
 *
 * @return array with updated values
 */
add_filter( 'autoptimize_filter_css_replacetag', 'custom_autoptimize_css_location', 10, 1 );
function custom_autoptimize_css_location( $location ) {
	$location[0] = "</head>"; // tag
	$location[1] = "before"; // injection

	return $location;
}

function get_company_logo( $size = 'medium', $title = null ) {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogo( $size, $title );
}

function get_company_logo_id() {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogoID();
}

function get_company_logo_url( $size = 'medium' ) {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogoURL( $size );
}

function get_archive_title() {
	return \BaseTheme\Basics\ThemeSupport::getArchiveTitle();
}

add_filter( 'href_phone_number', function ( $phone_number ) {
	return preg_replace( '/[^\d\+]+/i', '', preg_replace( '/\(.+\)/i', '', $phone_number ) );
} );