<?php

namespace BaseTheme\Basics;

class ThemeOptions {

	public static $wp_editor_settings = array(
		'wpautop'       => false,
		'textarea_rows' => 5,
		'tinymce'       => array( 'plugins' => 'wordpress,wplink' )
	);

	public static function init() {
		add_filter( 'optionsframework_menu', array( static::class, 'customThemeOptionsMenuParams' ) );
	}

	/**
	 * Change the menu title name and slug.
	 */
	public static function customThemeOptionsMenuParams( $menu ) {
		$menu['page_title'] = _x( 'Thema instellingen', 'Back-end thema instellingen', 'base-theme' );
		$menu['menu_title'] = _x( 'Thema instellingen', 'Back-end menu', 'base-theme' );
		$menu['menu_slug']  = 'theme-options';

		return $menu;
	}

	/**
	 * A unique identifier is defined to store the options in the database and reference them from the theme.
	 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
	 * If the identifier changes, it'll appear as if the options have been reset.
	 */
	public static function setOptionName() {
		$themename                       = get_option( 'stylesheet' );
		$themename                       = preg_replace( '/\W/', "_", strtolower( $themename ) );
		$optionsframework_settings       = get_option( 'optionsframework' );
		$optionsframework_settings['id'] = $themename;
		update_option( 'optionsframework', $optionsframework_settings );
	}

	/**
	 * Defines an array of options that will be used to generate the settings page and be saved in the database.
	 * When creating the "id" fields, make sure to use all lowercase and no spaces.
	 */
	public static function getOptions() {
		$options                    = array();
		$options[]                  = array(
			"name" => _x( 'Bedrijf', 'Back-end thema instellingen', 'base-theme' ),
			"type" => "heading"
		);
		$options['company']         = array(
			"name" => _x( 'Bedrijfsnaam', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "company",
			'std'  => '',
			"type" => "text"
		);
		$options['street']          = array(
			"name" => _x( 'Straat', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "street",
			'std'  => '',
			"type" => "text"
		);
		$options['number']          = array(
			"name" => _x( 'Nummer', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "number",
			'std'  => '',
			"type" => "text"
		);
		$options['zip']             = array(
			"name" => _x( 'Postcode', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "zip",
			'std'  => '',
			"type" => "text"
		);
		$options['city']            = array(
			"name" => _x( 'Plaats', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "city",
			'std'  => '',
			"type" => "text"
		);
		$options['phone']           = array(
			"name" => _x( 'Telefoonnummer', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "phone",
			'std'  => '',
			"type" => "text"
		);
		$options['company_logo']    = array(
			"name" => _x( 'Logo', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "company_logo",
			"type" => "upload"
		);
		$options['copyright_start'] = array(
			"name" => _x( 'Copyright jaar', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "copyright_start",
			'std'  => '',
			"type" => "text"
		);

		$options = apply_filters( 'optionsframework_options_filter_company', $options, static::$wp_editor_settings );

		$options[]                   = array(
			"name" => _x( '404 Pagina niet gevonden', 'Back-end thema instellingen', 'base-theme' ),
			"type" => "heading"
		);
		$options['404_page_banner']  = array(
			"name" => _x( 'Banner', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "404_page_banner",
			"type" => "upload"
		);
		$options['404_page_content'] = array(
			'name'     => _x( 'Content', 'Back-end thema instellingen', 'base-theme' ),
			'id'       => '404_page_content',
			'std'      => '',
			'type'     => 'editor',
			'settings' => static::$wp_editor_settings
		);

		$options = apply_filters( 'optionsframework_options_filter_404', $options, static::$wp_editor_settings );

		$options[]                            = array(
			"name" => _x( 'Zoeken', 'Back-end thema instellingen', 'base-theme' ),
			"type" => "heading"
		);
		$options['search_banner']             = array(
			"name" => _x( 'Banner', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "search_banner",
			"type" => "upload"
		);
		$options['no_search_results_content'] = array(
			'name'     => _x( 'Geen resultaten gevonden', 'Back-end thema instellingen', 'base-theme' ),
			'id'       => 'no_search_results_content',
			'std'      => '',
			'type'     => 'editor',
			'settings' => static::$wp_editor_settings
		);

		$options = apply_filters( 'optionsframework_options_filter_search', $options, static::$wp_editor_settings );

		$options[]                             = array(
			"name" => _x( 'Tags', 'Back-end thema instellingen', 'base-theme' ),
			"type" => "heading"
		);
		$options['default_tag_banner']         = array(
			"name" => _x( 'Default banner', 'Back-end thema instellingen', 'base-theme' ),
			"id"   => "default_tag_banner",
			"type" => "upload"
		);
		$options['default_tag_banner_content'] = array(
			'name'     => _x( 'Default content', 'Back-end thema instellingen', 'base-theme' ),
			'id'       => 'default_tag_banner_content',
			'std'      => '',
			'type'     => 'editor',
			'settings' => static::$wp_editor_settings
		);

		$options = apply_filters( 'optionsframework_options_filter_tags', $options, static::$wp_editor_settings );

		return apply_filters( 'optionsframework_options_filter', $options, static::$wp_editor_settings );
	}

}