module.exports = function (grunt) {
    grunt.initConfig({
        pure_grids: {
            responsive: {
                dest: './pure.css',
                options: {
                    units: 24, // 24-column grid
                    mediaQueries: {
                        sm: 'screen and (min-width: 35.5em)', // 568px
                        md: 'screen and (min-width: 48em)',   // 768px
                        lg: 'screen and (min-width: 64em)',   // 1024px
                        xl: 'screen and (min-width: 80em)',   // 1280px
                        xxl: 'screen and (min-width: 90em)'   // 1440px
                    }
                }
            }
        }
    });

    grunt.loadNpmTasks('grunt-pure-grids');
    grunt.registerTask('default', ['pure_grids']);
};