<?php

load_theme_textdomain( 'base-theme', get_stylesheet_directory() . '/languages' );

\yndenz\Modules\JSON_LD\JSON_LD::init();

\BaseTheme\Basics\Reset::init();
\BaseTheme\Basics\ThemeSupport::init();
\BaseTheme\Basics\ThemeOptions::init();
\BaseTheme\Basics\Shortcodes::init();
\BaseTheme\Basics\Menu::init();
\BaseTheme\Basics\Sidebars::init();
\BaseTheme\Basics\Scripts::init();
\BaseTheme\Basics\Pagination::init();

if ( ! function_exists( 'print_rr' ) ) {
	/**
	 * This custom version of print_r saves a lot of typing
	 *
	 * @param mixed $var the variable to display
	 */
	function print_rr( $var ) {
		echo '<pre>';
		print_r( $var );
		echo '</pre>';
	}
}

if ( ! function_exists( 'dd' ) ) {
	/**
	 * Dump and die.
	 * Use for development only!
	 *
	 * @uses print_rr()
	 *
	 * @param mixed $var
	 */
	function dd( $var ) {
		print_rr( $var );
		die();
	}
}

if ( ! function_exists( 'is_yndenz' ) ) {
	/**
	 * Check if the visitor is an yndenz employee.
	 *
	 * @param string $IP
	 *
	 * @return bool
	 */
	function is_yndenz( $IP = '83.87.228.21' ) {
		return $_SERVER['REMOTE_ADDR'] === $IP;
	}
}

if ( ! function_exists( 'notify_yndenz' ) ) {
	/**
	 * Notify yndenz through Rocket Chat.
	 *
	 * @param string $token          The webhook integration token for Rocket Chat
	 * @param string $subject        Subject of the message you want to send
	 * @param string $message        Message you want to send
	 * @param array  $mail_addresses Optional e-mail addresses to send a notification too
	 *
	 * @return bool true if successful, false if request failed, response body if unexpected response
	 */
	function notify_yndenz( $token, $subject, $message, $mail_addresses = array() ) {
		if ( ! defined( 'YNDENZ_NOTIFICATION_TOKEN' ) ) {
			define( 'YNDENZ_NOTIFICATION_TOKEN', $token );
		}

		return \BaseTheme\Basics\Notification::send( $subject, $message, $mail_addresses );
	}
}

if ( ! function_exists( 'structured_content' ) ) {
	/**
	 * Display the page content using structured data.
	 *
	 * @param bool $echo If false, the page content will be returned.
	 *
	 * @return string|null
	 */
	function structured_content( $echo = true ) {
        $output = restructuredContent();

		if ( $echo ) {
			echo $output;
		} else {
			return $output;
		}

		return null;
	}
}

/**
 * autoptimize_filter_css_replacetag: where in the HTML is optimized CSS injected
 *
 * @param array $location array containing the html-tag and the method (inject "before", "after" or "replace")
 *
 * @return array with updated values
 */
add_filter( 'autoptimize_filter_css_replacetag', 'custom_autoptimize_css_location', 10, 1 );
function custom_autoptimize_css_location( $location ) {
	$location[0] = "</head>"; // tag
	$location[1] = "before"; // injection

	return $location;
}

function get_company_logo( $size = 'medium', $title = null ) {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogo( $size, $title );
}

function get_company_logo_id() {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogoID();
}

function get_company_logo_url( $size = 'medium' ) {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogoURL( $size );
}

function get_archive_title() {
	return \BaseTheme\Basics\ThemeSupport::getArchiveTitle();
}

add_filter( 'href_phone_number', function ( $phone_number ) {
	return preg_replace( '/[^\d\+]+/i', '', preg_replace( '/\(.+\)/i', '', $phone_number ) );
} );

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );

// Disables the block editor from managing widgets.
add_filter( 'use_widgets_block_editor', '__return_false' );

function get_seo_title () {
    return get_post_meta(get_the_ID(), '_yoast_wpseo_title', true);
}

function the_seo_title () {
    echo get_post_meta(get_the_ID(), '_yoast_wpseo_title', true);
}

function breadcrumbMicroformats ($breadcrumbs) {
    // Convert the breadcrumb to text without tags
    $breadcrumbs = strip_tags( $breadcrumbs, '<a>' );

    // Convert to array
    if (get_option('wpseo_titles')) {
        $separator = get_option('wpseo_titles')['breadcrumbs-sep'];
    } else {
        $separator = get_option('wpseo_internallinks')['breadcrumbs-sep'];
    }

    // Make an array of the breadcrumb items
    $items = explode($separator, $breadcrumbs);

    $formattedBreadcrumbs = '';

    // Create a breadcrumb list
    foreach ($items as $index => $item) {
        $active = '';

        // The active breadcrumb item doesn't have a link, so thats how we can set the active class
        if (!strstr($item, '<a')) {
            $active = 'class="active"';
            $item = '<a href="' . get_permalink() . '">' . $item . '</a>';
        }

        // Check which WPSEO version is used to determine the correct li format
        if (version_compare(WPSEO_VERSION, '7.7', '<')) {
            $item = '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" ' . $active .'>' . $item . '<meta itemprop="position" content="' . ($index + 1) . '"/></li>';
        } else {
            $item = '<li '. $active .'>'. $item .'</li>';
        }

        $formattedBreadcrumbs .= $item;
    }

    // Check which version of WPSEO is used to determine to use ol or ul
    if (version_compare(WPSEO_VERSION, '7.7', '<')) {
        $output = '<ol itemprop="breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList" class="breadcrumb">' . $formattedBreadcrumbs . '</ol>';
    } else {
        $output = '<ul class="breadcrumb">' . $formattedBreadcrumbs . '</ul>';
    }

    return $output;
}

add_filter('wpseo_breadcrumb_output', 'breadcrumbMicroformats');

function restructuredContent( $include_date = false, $after_title = '' ) {
    global $post;

    $content = $post->post_content;

    // Add the title if it's not already in the content
    if ( preg_match( '/<h1(.*)>(.*)<\/h1>/i', $post->post_content ) <= 0 ) :
        $content = '<h1>' . get_the_title() . '</h1>' . $content;
    endif;

    $content_filtered = apply_filters( 'the_content', $content );

    if ( version_compare( WPSEO_VERSION, '11.0', '<' ) ) {
        $title = '<h1 itemprop="name"$1>$2</h1>';
    } else {
        $title = '<h1$1>$2</h1>';
    }

    $date = '';
    if ( $include_date ) {
        $datetime = get_the_time( 'Y-m-d' );
        if ( version_compare( WPSEO_VERSION, '11.0', '<' ) ) {
            $date = sprintf( '<time datetime="%s" pubdate itemprop="datePublished" content="%s">%s</time>', $datetime, $datetime, get_the_date() );
            $date .= sprintf( '<meta itemprop="dateModified" content="%s"/>', get_the_modified_time( 'Y-m-d' ) );
        } else {
            $date = sprintf( '<time datetime="%s">%s</time>', $datetime, get_the_date() );
        }
    }

    $page_header = sprintf( '<header class="page-header">%s</header>', $title . $date . $after_title );

    $content_restructured = preg_replace( '/<h1(.*)>(.*)<\/h1>/i', $page_header, $content_filtered );
    if ( version_compare( WPSEO_VERSION, '11.0', '<' ) ) {
        $content_restructured = preg_replace( '/<p([^>]*)>/i', '<p itemprop="description"$1>', $content_restructured, 1 );
    }

    return $content_restructured;
}