<div class="ybt-address">
    <address>
        <p class="organization-name">
            <a href="<?php echo home_url( '/' ); ?>" title="<?php the_seo_title( null, home_url( '/' ) ); ?>">
				<?php echo of_get_option( 'company' ); ?>
            </a>
        </p>
        <p>
            <span class="street-address">
                <?php echo of_get_option( 'street' ) . ' ' . of_get_option( 'number' ); ?>
            </span><br/>
            <span class="postal-code">
                <?php echo of_get_option( 'zip' ); ?>
            </span><br/>
            <span class="locality">
                <?php echo of_get_option( 'city' ); ?>
            </span><br/>
            <span class="tel">
                <a href="tel:<?php echo preg_replace( '/[^\d\+]+/i', '', preg_replace( '/\(.+\)/i', '', of_get_option( 'phone' ) ) ); ?>"
                   title="<?php printf( _x( 'Bel %s', 'Footer adres', 'base-theme' ), get_bloginfo( 'name' ) ); ?>">
                    <?php echo of_get_option( 'phone' ); ?>
                </a>
            </span><br/>
            <span class="email">
                <a href="mailto:<?php echo get_option( 'admin_email' ); ?>"
                   title="<?php printf( _x( 'Stuur een e-mail naar %s', 'Footer adres', 'base-theme' ), get_bloginfo( 'name' ) ); ?>">
                    <?php echo get_option( 'admin_email' ); ?>
                </a>
            </span>
        </p>
        <p class="social">
			<?php
			$social       = get_option( 'wpseo_social' );
			$allowed_keys = [
				'facebook_site',
				'twitter_site',
				'instagram_url',
				'linkedin_url',
				'myspace_url',
				'pinterest_url',
				'google_plus_url',
				'youtube_url'
			];
			$urls         = array_filter( array_intersect_key( $social, array_flip( $allowed_keys ) ) );
			foreach ( $urls as $key => $url ) :
				if ( $key === 'twitter_site' ) :
					$url = 'https://www.twitter.com/' . $url;
				endif;
				$title = ucwords( str_replace( '_', ' ', str_replace( array( '_site', '_url' ), '', $key ) ) );
				?>
                <a href="<?php echo $url; ?>" target="_blank" rel="nofollow noopener"
                   title="<?php printf( _x( 'Volg ons op %s', 'Footer adres', 'base-theme' ), $title ); ?>">
                    <i class="fa fa-<?php echo sanitize_title( $title ); ?>"></i>
                    <span class="sr-only"><?php echo $title; ?></span>
                </a>
			<?php
			endforeach;
			?>
        </p>
		<?php $company_logo_id = get_company_logo_id();
		if ( ! empty( $company_logo_id ) ) : ?>
            <div class="company-logo">
				<?php
				$alt_title = get_seo_title( get_option( 'page_on_front' ) );
				echo wp_get_attachment_image( $company_logo_id, 'medium', false, array(
					'alt'      => $alt_title,
					'title'    => $alt_title,
					'class'    => 'img-responsive'
				) );
				?>
            </div>
		<?php endif; ?>
    </address>
</div>

