const gulp = require('gulp');
const sass = require('gulp-sass')(require('sass'));
const sourcemaps = require('gulp-sourcemaps');
const babel = require('gulp-babel');
const uglify = require('gulp-uglify');
const rename = require('gulp-rename');
const cleanCSS = require('gulp-clean-css');
const autoprefixer = require('gulp-autoprefixer');

const paths = {
    scripts: {
        src: ['js/*.js', '!js/*.min.js', '!js/jquery-placeholder.js', '!js/main.js']
    },
    styles: {
        src: ['pure.css']
    }
};

function scripts() {
    return gulp.src(paths.scripts.src)
        .pipe(babel({
            presets: ['@babel/preset-env']
        }))
        .pipe(uglify())
        .pipe(rename({ suffix: '.min' }))
        .pipe(gulp.dest('js'));
}

function styles() {
    return gulp.src(paths.styles.src)
        .pipe(sourcemaps.init())
        .pipe(sass({ outputStyle: 'compressed' }).on('error', sass.logError))
        .pipe(autoprefixer())
        .pipe(cleanCSS())
        .pipe(rename({ suffix: '.min' }))
        .pipe(sourcemaps.write('.'))
        .pipe(gulp.dest('./'));
}

function watchFiles() {
    gulp.watch(paths.scripts.src, scripts);
}

gulp.task('styles', styles);
gulp.task('scripts', scripts);
gulp.task('watch', watchFiles);
gulp.task('default', gulp.parallel('styles', 'scripts'));