<?php

namespace BaseTheme\Basics;

class Sidebars extends Basics {

	public static function register() {
		if ( ! function_exists( 'register_sidebar' ) ) {
			return;
		}

		$sidebars = array(
			'primary-sidebar'      => array(
				'name'         => _x( 'Primaire sidebar', 'Back-end widgets', 'base-theme' ),
				'before_title' => '<h3 class="widget-title">',
				'after_title'  => '</h3>'
			),
			'archive-news-sidebar' => array(
				'name'         => _x( 'Nieuws archief sidebar', 'Back-end widgets', 'base-theme' ),
				'description'  => _x( 'Deze widgets worden weergegeven op het nieuws overzicht.', 'Back-end widgets', 'base-theme' ),
				'before_title' => '<h3 class="widget-title">',
				'after_title'  => '</h3>'
			),
			'single-news-sidebar'  => array(
				'name'         => _x( 'Nieuws bericht sidebar', 'Back-end widgets', 'base-theme' ),
				'description'  => _x( 'Deze widgets worden weergegeven op de nieuws pagina\'s.', 'Back-end widgets', 'base-theme' ),
				'before_title' => '<h2 class="widget-title">',
				'after_title'  => '</h2>'
			),
			'search-sidebar'       => array(
				'name'        => _x( 'Zoekenresultaten sidebar', 'Back-end widgets', 'base-theme' ),
				'description' => _x( 'Deze widgets worden weergegeven op de zoekresultaten pagina.', 'Back-end widgets', 'base-theme' ),
			)
		);

		array_walk( $sidebars, function ( &$sidebar, $id ) {
			$sidebar = wp_parse_args( $sidebar, array(
				'id'            => $id,
				'class'         => '',
				'before_widget' => '<div class="widget %2$s">',
				'after_widget'  => '</div>',
			) );
		} );

		$sidebars = apply_filters( 'base_theme_basics_sidebars', $sidebars );

		foreach ( $sidebars as $sidebar ) {
			register_sidebar( $sidebar );
		}
	}

}